/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.util.Set;
import org.jclouds.chef.domain.Attribute;
import org.jclouds.chef.domain.Metadata;
import org.jclouds.chef.domain.Resource;

public class CookbookVersion {
    private String name;
    private Set<Resource> definitions = Sets.newLinkedHashSet();
    private Set<Attribute> attributes = Sets.newLinkedHashSet();
    private Set<Resource> files = Sets.newLinkedHashSet();
    private Metadata metadata = new Metadata();
    private Set<Resource> providers = Sets.newLinkedHashSet();
    @SerializedName(value="cookbook_name")
    private String cookbookName;
    private Set<Resource> resources = Sets.newLinkedHashSet();
    private Set<Resource> templates = Sets.newLinkedHashSet();
    private Set<Resource> libraries = Sets.newLinkedHashSet();
    private String version;
    private Set<Resource> recipes = Sets.newLinkedHashSet();
    @SerializedName(value="root_files")
    private Set<Resource> rootFiles = Sets.newLinkedHashSet();
    @SerializedName(value="json_class")
    private String _jsonClass = "Chef::CookbookVersion";
    @SerializedName(value="chef_type")
    private String _chefType = "cookbook_version";

    public CookbookVersion(String cookbookName, String version) {
        this.cookbookName = cookbookName;
        this.version = version;
        this.name = cookbookName + "-" + version;
    }

    public CookbookVersion(String name, Set<Resource> definitions, Set<Attribute> attributes, Set<Resource> files, Metadata metadata, Set<Resource> providers, String cookbookName, Set<Resource> resources, Set<Resource> templates, Set<Resource> libraries, String version, Set<Resource> recipes, Set<Resource> rootFiles) {
        this.name = name;
        Iterables.addAll(this.definitions, definitions);
        Iterables.addAll(this.attributes, attributes);
        Iterables.addAll(this.files, files);
        this.metadata = metadata;
        Iterables.addAll(this.providers, providers);
        this.cookbookName = cookbookName;
        Iterables.addAll(this.resources, resources);
        Iterables.addAll(this.templates, templates);
        Iterables.addAll(this.libraries, libraries);
        this.version = version;
        Iterables.addAll(this.recipes, recipes);
        Iterables.addAll(this.rootFiles, rootFiles);
    }

    CookbookVersion() {
    }

    public String getName() {
        return this.name;
    }

    public Set<Resource> getDefinitions() {
        return this.definitions;
    }

    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    public Set<Resource> getFiles() {
        return this.files;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Set<Resource> getSuppliers() {
        return this.providers;
    }

    public String getCookbookName() {
        return this.cookbookName;
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public Set<Resource> getTemplates() {
        return this.templates;
    }

    public Set<Resource> getLibraries() {
        return this.libraries;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<Resource> getRecipes() {
        return this.recipes;
    }

    public Set<Resource> getRootFiles() {
        return this.rootFiles;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : ((Object)this.attributes).hashCode());
        result = 31 * result + (this.cookbookName == null ? 0 : this.cookbookName.hashCode());
        result = 31 * result + (this.definitions == null ? 0 : ((Object)this.definitions).hashCode());
        result = 31 * result + (this.files == null ? 0 : ((Object)this.files).hashCode());
        result = 31 * result + (this.libraries == null ? 0 : ((Object)this.libraries).hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.providers == null ? 0 : ((Object)this.providers).hashCode());
        result = 31 * result + (this.recipes == null ? 0 : ((Object)this.recipes).hashCode());
        result = 31 * result + (this.resources == null ? 0 : ((Object)this.resources).hashCode());
        result = 31 * result + (this.rootFiles == null ? 0 : ((Object)this.rootFiles).hashCode());
        result = 31 * result + (this.templates == null ? 0 : ((Object)this.templates).hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CookbookVersion other = (CookbookVersion)obj;
        if (this.attributes == null ? other.attributes != null : !((Object)this.attributes).equals(other.attributes)) {
            return false;
        }
        if (this.cookbookName == null ? other.cookbookName != null : !this.cookbookName.equals(other.cookbookName)) {
            return false;
        }
        if (this.definitions == null ? other.definitions != null : !((Object)this.definitions).equals(other.definitions)) {
            return false;
        }
        if (this.files == null ? other.files != null : !((Object)this.files).equals(other.files)) {
            return false;
        }
        if (this.libraries == null ? other.libraries != null : !((Object)this.libraries).equals(other.libraries)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.providers == null ? other.providers != null : !((Object)this.providers).equals(other.providers)) {
            return false;
        }
        if (this.recipes == null ? other.recipes != null : !((Object)this.recipes).equals(other.recipes)) {
            return false;
        }
        if (this.resources == null ? other.resources != null : !((Object)this.resources).equals(other.resources)) {
            return false;
        }
        if (this.rootFiles == null ? other.rootFiles != null : !((Object)this.rootFiles).equals(other.rootFiles)) {
            return false;
        }
        if (this.templates == null ? other.templates != null : !((Object)this.templates).equals(other.templates)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "Cookbook [attributes=" + this.attributes + ", cookbookName=" + this.cookbookName + ", definitions=" + this.definitions + ", files=" + this.files + ", libraries=" + this.libraries + ", metadata=" + this.metadata + ", name=" + this.name + ", providers=" + this.providers + ", recipes=" + this.recipes + ", resources=" + this.resources + ", rootFiles=" + this.rootFiles + ", templates=" + this.templates + ", version=" + this.version + "]";
    }
}

