/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import org.jclouds.domain.JsonBall;

public class Environment {
    private String name;
    @SerializedName(value="default_attributes")
    private Map<String, JsonBall> attributes = Maps.newLinkedHashMap();
    @SerializedName(value="override_attributes")
    private Map<String, JsonBall> overrideAttributes = Maps.newLinkedHashMap();
    private String description = "";
    @SerializedName(value="cookbook_versions")
    private Map<String, String> cookbookVersions = Maps.newLinkedHashMap();
    @SerializedName(value="json_class")
    private String _jsonClass = "Chef::Environment";
    @SerializedName(value="chef_type")
    private String _chefType = "environment";

    public Environment(String name, Map<String, JsonBall> attributes, Map<String, JsonBall> overrideAttributes, String description, Map<String, String> cookbookVersions) {
        this.name = name;
        this.attributes.putAll(attributes);
        this.overrideAttributes.putAll(overrideAttributes);
        this.description = description;
        this.cookbookVersions.putAll(cookbookVersions);
    }

    public Environment(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public Environment(String name) {
        this(name, null);
    }

    Environment() {
    }

    public String getName() {
        return this.name;
    }

    public Map<String, JsonBall> getAttributes() {
        return this.attributes;
    }

    public Map<String, JsonBall> getOverrideAttributes() {
        return this.overrideAttributes;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getCookbookVersions() {
        return this.cookbookVersions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment that = (Environment)o;
        if (this.attributes != null ? !((Object)this.attributes).equals(that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.cookbookVersions != null ? !((Object)this.cookbookVersions).equals(that.cookbookVersions) : that.cookbookVersions != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.overrideAttributes != null ? !((Object)this.overrideAttributes).equals(that.overrideAttributes) : that.overrideAttributes != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.attributes != null ? ((Object)this.attributes).hashCode() : 0);
        result = 31 * result + (this.overrideAttributes != null ? ((Object)this.overrideAttributes).hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.cookbookVersions != null ? ((Object)this.cookbookVersions).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "[name='" + this.name + '\'' + ", attributes=" + this.attributes + ", overrideAttributes=" + this.overrideAttributes + ", description='" + this.description + '\'' + ", cookbookVersions=" + this.cookbookVersions + ']';
    }
}

