/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import org.jclouds.chef.domain.Attribute;

public class Metadata {
    private String license;
    private String maintainer;
    private Map<String, String> suggestions = Maps.newLinkedHashMap();
    private Map<String, String> dependencies = Maps.newLinkedHashMap();
    @SerializedName(value="maintainer_email")
    private String maintainerEmail;
    private Map<String, String> conflicting = Maps.newLinkedHashMap();
    private String description;
    private Map<String, String> providing = Maps.newLinkedHashMap();
    private Map<String, String> platforms = Maps.newLinkedHashMap();
    private String version;
    private Map<String, String> recipes = Maps.newLinkedHashMap();
    private Map<String, String> replacing = Maps.newLinkedHashMap();
    private String name;
    private Map<String, String> groupings = Maps.newLinkedHashMap();
    @SerializedName(value="long_description")
    private String longDescription;
    private Map<String, Attribute> attributes = Maps.newLinkedHashMap();
    private Map<String, String> recommendations = Maps.newLinkedHashMap();

    public Metadata(String license, String maintainer, Map<String, String> suggestions, Map<String, String> dependencies, String maintainerEmail, Map<String, String> conflicting, String description, Map<String, String> providing, Map<String, String> platforms, String version, Map<String, String> recipes, Map<String, String> replacing, String name, Map<String, String> groupings, String longDescription, Map<String, Attribute> attributes, Map<String, String> recommendations) {
        this.license = license;
        this.maintainer = maintainer;
        this.suggestions.putAll(suggestions);
        this.dependencies.putAll(dependencies);
        this.maintainerEmail = maintainerEmail;
        this.conflicting.putAll(conflicting);
        this.description = description;
        this.providing.putAll(providing);
        this.platforms.putAll(platforms);
        this.version = version;
        this.recipes.putAll(recipes);
        this.replacing.putAll(replacing);
        this.name = name;
        this.groupings.putAll(groupings);
        this.longDescription = longDescription;
        this.attributes.putAll(attributes);
        this.recommendations.putAll(recommendations);
    }

    public Metadata() {
    }

    public String getLicense() {
        return this.license;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public Map<String, String> getSuggestions() {
        return this.suggestions;
    }

    public Map<String, String> getDependencies() {
        return this.dependencies;
    }

    public String getMaintainerEmail() {
        return this.maintainerEmail;
    }

    public Map<String, String> getConflicting() {
        return this.conflicting;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getProviding() {
        return this.providing;
    }

    public Map<String, String> getPlatforms() {
        return this.platforms;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getRecipes() {
        return this.recipes;
    }

    public Map<String, String> getReplacing() {
        return this.replacing;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getGroupings() {
        return this.groupings;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getRecommendations() {
        return this.recommendations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : ((Object)this.attributes).hashCode());
        result = 31 * result + (this.conflicting == null ? 0 : ((Object)this.conflicting).hashCode());
        result = 31 * result + (this.dependencies == null ? 0 : ((Object)this.dependencies).hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.groupings == null ? 0 : ((Object)this.groupings).hashCode());
        result = 31 * result + (this.license == null ? 0 : this.license.hashCode());
        result = 31 * result + (this.longDescription == null ? 0 : this.longDescription.hashCode());
        result = 31 * result + (this.maintainer == null ? 0 : this.maintainer.hashCode());
        result = 31 * result + (this.maintainerEmail == null ? 0 : this.maintainerEmail.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.platforms == null ? 0 : ((Object)this.platforms).hashCode());
        result = 31 * result + (this.providing == null ? 0 : ((Object)this.providing).hashCode());
        result = 31 * result + (this.recipes == null ? 0 : ((Object)this.recipes).hashCode());
        result = 31 * result + (this.recommendations == null ? 0 : ((Object)this.recommendations).hashCode());
        result = 31 * result + (this.replacing == null ? 0 : ((Object)this.replacing).hashCode());
        result = 31 * result + (this.suggestions == null ? 0 : ((Object)this.suggestions).hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metadata other = (Metadata)obj;
        if (this.attributes == null ? other.attributes != null : !((Object)this.attributes).equals(other.attributes)) {
            return false;
        }
        if (this.conflicting == null ? other.conflicting != null : !((Object)this.conflicting).equals(other.conflicting)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !((Object)this.dependencies).equals(other.dependencies)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.groupings == null ? other.groupings != null : !((Object)this.groupings).equals(other.groupings)) {
            return false;
        }
        if (this.license == null ? other.license != null : !this.license.equals(other.license)) {
            return false;
        }
        if (this.longDescription == null ? other.longDescription != null : !this.longDescription.equals(other.longDescription)) {
            return false;
        }
        if (this.maintainer == null ? other.maintainer != null : !this.maintainer.equals(other.maintainer)) {
            return false;
        }
        if (this.maintainerEmail == null ? other.maintainerEmail != null : !this.maintainerEmail.equals(other.maintainerEmail)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.platforms == null ? other.platforms != null : !((Object)this.platforms).equals(other.platforms)) {
            return false;
        }
        if (this.providing == null ? other.providing != null : !((Object)this.providing).equals(other.providing)) {
            return false;
        }
        if (this.recipes == null ? other.recipes != null : !((Object)this.recipes).equals(other.recipes)) {
            return false;
        }
        if (this.recommendations == null ? other.recommendations != null : !((Object)this.recommendations).equals(other.recommendations)) {
            return false;
        }
        if (this.replacing == null ? other.replacing != null : !((Object)this.replacing).equals(other.replacing)) {
            return false;
        }
        if (this.suggestions == null ? other.suggestions != null : !((Object)this.suggestions).equals(other.suggestions)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "Metadata [attributes=" + this.attributes + ", conflicting=" + this.conflicting + ", dependencies=" + this.dependencies + ", description=" + this.description + ", groupings=" + this.groupings + ", license=" + this.license + ", longDescription=" + this.longDescription + ", maintainer=" + this.maintainer + ", maintainerEmail=" + this.maintainerEmail + ", name=" + this.name + ", platforms=" + this.platforms + ", providing=" + this.providing + ", recipes=" + this.recipes + ", recommendations=" + this.recommendations + ", replacing=" + this.replacing + ", suggestions=" + this.suggestions + ", version=" + this.version + "]";
    }
}

