/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import org.jclouds.domain.JsonBall;
import org.jclouds.javax.annotation.Nullable;

public class Node {
    private String name;
    private Map<String, JsonBall> normal = Maps.newLinkedHashMap();
    private Map<String, JsonBall> override = Maps.newLinkedHashMap();
    @SerializedName(value="default")
    private Map<String, JsonBall> defaultA = Maps.newLinkedHashMap();
    private Map<String, JsonBall> automatic = Maps.newLinkedHashMap();
    @SerializedName(value="run_list")
    private List<String> runList = Lists.newArrayList();
    @SerializedName(value="chef_environment")
    @Nullable
    private String chefEnvironment;
    @SerializedName(value="json_class")
    private String _jsonClass = "Chef::Node";
    @SerializedName(value="chef_type")
    private String _chefType = "node";

    public Node(String name, Map<String, JsonBall> normal, Map<String, JsonBall> override, Map<String, JsonBall> defaultA, Map<String, JsonBall> automatic, Iterable<String> runList) {
        this(name, normal, override, defaultA, automatic, runList, null);
    }

    public Node(String name, Map<String, JsonBall> normal, Map<String, JsonBall> override, Map<String, JsonBall> defaultA, Map<String, JsonBall> automatic, Iterable<String> runList, String chefEnvironment) {
        this.name = name;
        this.chefEnvironment = chefEnvironment;
        this.normal.putAll(normal);
        this.override.putAll(override);
        this.defaultA.putAll(defaultA);
        this.automatic.putAll(automatic);
        Iterables.addAll(this.runList, runList);
    }

    public String toString() {
        return "Node [name=" + this.name + ", runList=" + this.runList + ", normal=" + this.normal + ", default=" + this.defaultA + ", override=" + this.override + ", chefEnvironment=" + this.chefEnvironment + ", automatic=" + this.automatic + "]";
    }

    public Node(String name, Iterable<String> runList) {
        this(name, runList, "_default");
    }

    public Node(String name, Iterable<String> runList, String chefEnvironment) {
        this.name = name;
        this.chefEnvironment = chefEnvironment;
        Iterables.addAll(this.runList, runList);
    }

    Node() {
    }

    public String getName() {
        return this.name;
    }

    public Map<String, JsonBall> getNormal() {
        return this.normal;
    }

    public Map<String, JsonBall> getOverride() {
        return this.override;
    }

    public Map<String, JsonBall> getDefault() {
        return this.defaultA;
    }

    public Map<String, JsonBall> getAutomatic() {
        return this.automatic;
    }

    public List<String> getRunList() {
        return this.runList;
    }

    public String getChefEnvironment() {
        return this.chefEnvironment;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._chefType == null ? 0 : this._chefType.hashCode());
        result = 31 * result + (this._jsonClass == null ? 0 : this._jsonClass.hashCode());
        result = 31 * result + (this.automatic == null ? 0 : ((Object)this.automatic).hashCode());
        result = 31 * result + (this.defaultA == null ? 0 : ((Object)this.defaultA).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.normal == null ? 0 : ((Object)this.normal).hashCode());
        result = 31 * result + (this.override == null ? 0 : ((Object)this.override).hashCode());
        result = 31 * result + (this.runList == null ? 0 : ((Object)this.runList).hashCode());
        result = 31 * result + (this.chefEnvironment == null ? 0 : this.chefEnvironment.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this._chefType == null ? other._chefType != null : !this._chefType.equals(other._chefType)) {
            return false;
        }
        if (this._jsonClass == null ? other._jsonClass != null : !this._jsonClass.equals(other._jsonClass)) {
            return false;
        }
        if (this.automatic == null ? other.automatic != null : !((Object)this.automatic).equals(other.automatic)) {
            return false;
        }
        if (this.defaultA == null ? other.defaultA != null : !((Object)this.defaultA).equals(other.defaultA)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.normal == null ? other.normal != null : !((Object)this.normal).equals(other.normal)) {
            return false;
        }
        if (this.override == null ? other.override != null : !((Object)this.override).equals(other.override)) {
            return false;
        }
        if (this.runList == null ? other.runList != null : !((Object)this.runList).equals(other.runList)) {
            return false;
        }
        return !(this.chefEnvironment == null ? other.chefEnvironment != null : !this.chefEnvironment.equals(other.chefEnvironment));
    }
}

