/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.primitives.Bytes;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import org.jclouds.io.payloads.FilePayload;

public class Resource {
    private String name;
    private URI url;
    private byte[] checksum;
    private String path;
    private String specificity;

    public Resource(FilePayload payload) {
        this(((File)payload.getRawContent()).getName(), null, payload.getContentMetadata().getContentMD5(), ((File)payload.getRawContent()).getPath(), "default");
    }

    public Resource(String name, byte[] checksum, String path) {
        this(name, null, checksum, path, "default");
    }

    public Resource(String name, URI url, byte[] checksum, String path, String specificity) {
        this.name = name;
        this.url = url;
        this.checksum = checksum;
        this.path = path;
        this.specificity = specificity;
    }

    Resource() {
    }

    public String getName() {
        return this.name;
    }

    public URI getUrl() {
        return this.url;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public String getPath() {
        return this.path;
    }

    public String getSpecificity() {
        return this.specificity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.checksum);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.specificity == null ? 0 : this.specificity.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (!Arrays.equals(this.checksum, other.checksum)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.specificity == null ? other.specificity != null : !this.specificity.equals(other.specificity)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return "Resource [checksum=" + Bytes.asList((byte[])this.checksum) + ", name=" + this.name + ", path=" + this.path + ", specificity=" + this.specificity + ", url=" + this.url + "]";
    }
}

