/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import org.jclouds.domain.JsonBall;

public class Role {
    private String name;
    private String description;
    @SerializedName(value="override_attributes")
    private Map<String, JsonBall> override = Maps.newLinkedHashMap();
    @SerializedName(value="default_attributes")
    private Map<String, JsonBall> defaultA = Maps.newLinkedHashMap();
    @SerializedName(value="run_list")
    private List<String> runList = Lists.newArrayList();
    @SerializedName(value="json_class")
    private String _jsonClass = "Chef::Role";
    @SerializedName(value="chef_type")
    private String _chefType = "role";

    public Role(String name, String description, Map<String, JsonBall> defaultA, List<String> runList, Map<String, JsonBall> override) {
        this.name = name;
        this.description = description;
        this.defaultA = defaultA;
        this.runList = runList;
        this.override = override;
    }

    public Role(String name, Iterable<String> runList) {
        this.name = name;
        Iterables.addAll(this.runList, runList);
    }

    Role() {
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, JsonBall> getOverride() {
        return this.override;
    }

    public Map<String, JsonBall> getDefault() {
        return this.defaultA;
    }

    public List<String> getRunList() {
        return this.runList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._chefType == null ? 0 : this._chefType.hashCode());
        result = 31 * result + (this._jsonClass == null ? 0 : this._jsonClass.hashCode());
        result = 31 * result + (this.defaultA == null ? 0 : ((Object)this.defaultA).hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.override == null ? 0 : ((Object)this.override).hashCode());
        result = 31 * result + (this.runList == null ? 0 : ((Object)this.runList).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        if (this._chefType == null ? other._chefType != null : !this._chefType.equals(other._chefType)) {
            return false;
        }
        if (this._jsonClass == null ? other._jsonClass != null : !this._jsonClass.equals(other._jsonClass)) {
            return false;
        }
        if (this.defaultA == null ? other.defaultA != null : !((Object)this.defaultA).equals(other.defaultA)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.override == null ? other.override != null : !((Object)this.override).equals(other.override)) {
            return false;
        }
        return !(this.runList == null ? other.runList != null : !((Object)this.runList).equals(other.runList));
    }

    public String toString() {
        return "[name=" + this.name + ", description=" + this.description + ", defaultA=" + this.defaultA + ", override=" + this.override + ", runList=" + this.runList + "]";
    }
}

