/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Set;

public class Sandbox {
    @SerializedName(value="_rev")
    private String rev;
    @SerializedName(value="is_completed")
    private boolean isCompleted;
    @SerializedName(value="create_time")
    private Date createTime;
    private Set<String> checksums = Sets.newLinkedHashSet();
    private String name;
    private String guid;
    @SerializedName(value="json_class")
    private String _jsonClass = "Chef::Sandbox";
    @SerializedName(value="chef_type")
    private String _chefType = "sandbox";

    public Sandbox(String rev, boolean isCompleted, Date createTime, Iterable<String> checksums, String name, String guid) {
        this.rev = rev;
        this.isCompleted = isCompleted;
        this.createTime = createTime;
        Iterables.addAll(this.checksums, checksums);
        this.name = name;
        this.guid = guid;
    }

    public Sandbox() {
    }

    public String getRev() {
        return this.rev;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Set<String> getChecksums() {
        return this.checksums;
    }

    public String getName() {
        return this.name;
    }

    public String getGuid() {
        return this.guid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksums == null ? 0 : ((Object)this.checksums).hashCode());
        result = 31 * result + (this.createTime == null ? 0 : this.createTime.hashCode());
        result = 31 * result + (this.guid == null ? 0 : this.guid.hashCode());
        result = 31 * result + (this.isCompleted ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.rev == null ? 0 : this.rev.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sandbox other = (Sandbox)obj;
        if (this.checksums == null ? other.checksums != null : !((Object)this.checksums).equals(other.checksums)) {
            return false;
        }
        if (this.createTime == null ? other.createTime != null : !this.createTime.equals(other.createTime)) {
            return false;
        }
        if (this.guid == null ? other.guid != null : !this.guid.equals(other.guid)) {
            return false;
        }
        if (this.isCompleted != other.isCompleted) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.rev == null ? other.rev != null : !this.rev.equals(other.rev));
    }

    public String toString() {
        return "Sandbox [checksums=" + this.checksums + ", createTime=" + this.createTime + ", guid=" + this.guid + ", isCompleted=" + this.isCompleted + ", name=" + this.name + ", rev=" + this.rev + "]";
    }
}

