/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.domain.JsonBall;

@Singleton
public class BootstrapConfigForGroup
implements Function<String, DatabagItem> {
    public static final Type BOOTSTRAP_CONFIG_TYPE = new TypeLiteral<Map<String, JsonBall>>(){}.getType();
    private final ChefApi api;
    private final String databag;

    @Inject
    public BootstrapConfigForGroup(@Named(value="chef.bootstrap-databag") String databag, ChefApi api) {
        this.databag = (String)Preconditions.checkNotNull((Object)databag, (Object)"databag");
        this.api = (ChefApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    public DatabagItem apply(String from) {
        DatabagItem bootstrapConfig = this.api.getDatabagItem(this.databag, from);
        Preconditions.checkState((bootstrapConfig != null ? 1 : 0) != 0, (String)"databag item %s/%s not found", (Object[])new Object[]{this.databag, from});
        return bootstrapConfig;
    }
}

