/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Client;

@Singleton
public class ClientForGroup
implements Function<String, Client> {
    private final ChefApi chefApi;

    @Inject
    public ClientForGroup(ChefApi chefApi) {
        this.chefApi = (ChefApi)Preconditions.checkNotNull((Object)chefApi, (Object)"chefApi");
    }

    public Client apply(String from) {
        String clientName = ClientForGroup.findNextClientName(this.chefApi.listClients(), from + "-client-%02d");
        Client client = this.chefApi.createClient(clientName);
        return new Client(null, null, clientName, clientName, false, client.getPrivateKey());
    }

    private static String findNextClientName(Set<String> clients, String pattern) {
        String clientName;
        HashSet names = Sets.newHashSet(clients);
        int index = 0;
        while (names.contains(clientName = String.format(pattern, index++))) {
        }
        return clientName;
    }
}

