/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.config.Validator;
import org.jclouds.crypto.Pems;
import org.jclouds.domain.JsonBall;
import org.jclouds.json.Json;
import org.jclouds.location.Provider;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

@Singleton
public class GroupToBootScript
implements Function<String, Statement> {
    @VisibleForTesting
    static final Type RUN_LIST_TYPE = new TypeLiteral<Map<String, List<String>>>(){}.getType();
    private final Supplier<URI> endpoint;
    private final Json json;
    private final CacheLoader<String, ? extends JsonBall> bootstrapConfigForGroup;
    private final Statement installChefGems;
    private final Optional<String> validatorName;
    private final Optional<PrivateKey> validatorCredential;

    @Inject
    public GroupToBootScript(@Provider Supplier<URI> endpoint, Json json, CacheLoader<String, ? extends JsonBall> bootstrapConfigForGroup, @Named(value="installChefGems") Statement installChefGems, @Validator Optional<String> validatorName, @Validator Optional<PrivateKey> validatorCredential) {
        this.endpoint = (Supplier)Preconditions.checkNotNull(endpoint, (Object)"endpoint");
        this.json = (Json)Preconditions.checkNotNull((Object)json, (Object)"json");
        this.bootstrapConfigForGroup = (CacheLoader)Preconditions.checkNotNull(bootstrapConfigForGroup, (Object)"bootstrapConfigForGroup");
        this.installChefGems = (Statement)Preconditions.checkNotNull((Object)installChefGems, (Object)"installChefGems");
        this.validatorName = (Optional)Preconditions.checkNotNull(validatorName, (Object)"validatorName");
        this.validatorCredential = (Optional)Preconditions.checkNotNull(validatorCredential, validatorCredential);
    }

    public Statement apply(String group) {
        Preconditions.checkNotNull((Object)group, (Object)"group");
        String validatorClientName = (String)this.validatorName.get();
        PrivateKey validatorKey = (PrivateKey)this.validatorCredential.get();
        JsonBall bootstrapConfig = null;
        try {
            bootstrapConfig = (JsonBall)this.bootstrapConfigForGroup.load((Object)group);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        String chefConfigDir = "{root}etc{fs}chef";
        Statement createChefConfigDir = Statements.exec((String)("{md} " + chefConfigDir));
        Statement createClientRb = Statements.appendFile((String)(chefConfigDir + "{fs}client.rb"), (Iterable)ImmutableList.of((Object)"require 'rubygems'", (Object)"require 'ohai'", (Object)"o = Ohai::System.new", (Object)"o.all_plugins", (Object)String.format("node_name \"%s-\" + o[:ipaddress]", group), (Object)"log_level :info", (Object)"log_location STDOUT", (Object)String.format("validation_client_name \"%s\"", validatorClientName), (Object)String.format("chef_server_url \"%s\"", this.endpoint.get())));
        Statement createValidationPem = Statements.appendFile((String)(chefConfigDir + "{fs}validation.pem"), (Iterable)Splitter.on((char)'\n').split((CharSequence)Pems.pem((PrivateKey)validatorKey)));
        String chefBootFile = chefConfigDir + "{fs}first-boot.json";
        Statement createFirstBoot = Statements.appendFile((String)chefBootFile, Collections.singleton(this.json.toJson((Object)bootstrapConfig)));
        Statement runChef = Statements.exec((String)("chef-client -j " + chefBootFile));
        return Statements.newStatementList((Statement[])new Statement[]{this.installChefGems, createChefConfigDir, createClientRb, createValidationPem, createFirstBoot, runChef});
    }
}

