/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.domain.CookbookDefinition;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;

@Singleton
public class ParseCookbookDefinitionListFromJsonv10
implements Function<HttpResponse, Set<CookbookDefinition>> {
    private final ParseJson<Map<String, CookbookDefinition>> parser;

    @Inject
    ParseCookbookDefinitionListFromJsonv10(ParseJson<Map<String, CookbookDefinition>> parser) {
        this.parser = parser;
    }

    public Set<CookbookDefinition> apply(HttpResponse response) {
        return Sets.newLinkedHashSet(((Map)this.parser.apply(response)).values());
    }
}

