/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.domain.CookbookDefinition;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;

@Singleton
public class ParseCookbookVersionsV10FromJson
implements Function<HttpResponse, Set<String>> {
    private final ParseJson<Map<String, CookbookDefinition>> parser;

    @Inject
    ParseCookbookVersionsV10FromJson(ParseJson<Map<String, CookbookDefinition>> parser) {
        this.parser = parser;
    }

    public Set<String> apply(HttpResponse response) {
        CookbookDefinition def = (CookbookDefinition)Iterables.getFirst(((Map)this.parser.apply(response)).values(), null);
        return Sets.newLinkedHashSet((Iterable)Iterables.transform(def.getVersions(), (Function)new Function<CookbookDefinition.Version, String>(){

            public String apply(CookbookDefinition.Version input) {
                return input.getVersion();
            }
        }));
    }
}

