/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.domain.SearchResult;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;

@Singleton
public class ParseSearchResultFromJson<T>
implements Function<HttpResponse, SearchResult<T>> {
    private final ParseJson<Response<T>> json;

    @Inject
    ParseSearchResultFromJson(ParseJson<Response<T>> json) {
        this.json = json;
    }

    public SearchResult<T> apply(HttpResponse arg0) {
        Response returnVal = (Response)this.json.apply(arg0);
        return new SearchResult(returnVal.start, returnVal.rows);
    }

    static class Response<T> {
        long start;
        List<T> rows;

        Response() {
        }
    }
}

