/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.functions.BootstrapConfigForGroup;
import org.jclouds.domain.JsonBall;
import org.jclouds.json.Json;

@Singleton
public class RunListForGroup
implements Function<String, List<String>> {
    public static final Type RUN_LIST_TYPE = new TypeLiteral<List<String>>(){}.getType();
    private final BootstrapConfigForGroup bootstrapConfigForGroup;
    private final Json json;

    @Inject
    public RunListForGroup(BootstrapConfigForGroup bootstrapConfigForGroup, Json json) {
        this.bootstrapConfigForGroup = (BootstrapConfigForGroup)Preconditions.checkNotNull((Object)bootstrapConfigForGroup, (Object)"bootstrapConfigForGroup");
        this.json = (Json)Preconditions.checkNotNull((Object)json, (Object)"json");
    }

    public List<String> apply(String from) {
        DatabagItem bootstrapConfig = this.bootstrapConfigForGroup.apply(from);
        Map config = (Map)this.json.fromJson(bootstrapConfig.toString(), BootstrapConfigForGroup.BOOTSTRAP_CONFIG_TYPE);
        JsonBall runlist = (JsonBall)config.get("run_list");
        return (List)this.json.fromJson(runlist.toString(), RUN_LIST_TYPE);
    }
}

