/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.handlers;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.functions.ParseErrorFromJsonOrReturnBody;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;

@Singleton
public class ChefErrorHandler
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    private final ParseErrorFromJsonOrReturnBody errorParser;

    @Inject
    ChefErrorHandler(ParseErrorFromJsonOrReturnBody errorParser) {
        this.errorParser = errorParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        String message = this.errorParser.apply(response);
        HttpResponseException exception = new HttpResponseException(command, response, message);
        try {
            message = message != null ? message : String.format("%s -> %s", command.getCurrentRequest().getRequestLine(), response.getStatusLine());
            switch (response.getStatusCode()) {
                case 401: 
                case 403: {
                    exception = new AuthorizationException(message, (Throwable)exception);
                    return;
                }
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) return;
                    exception = new ResourceNotFoundException(message, (Throwable)exception);
                    return;
                }
            }
            return;
        }
        finally {
            if (response.getPayload() != null) {
                try {
                    Closeables.close((Closeable)response.getPayload().getInput(), (boolean)true);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            command.setException((Exception)exception);
        }
    }
}

