/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefContext;
import org.jclouds.chef.ChefService;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.domain.Environment;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.functions.BootstrapConfigForGroup;
import org.jclouds.chef.functions.GroupToBootScript;
import org.jclouds.chef.functions.RunListForGroup;
import org.jclouds.chef.strategy.CleanupStaleNodesAndClients;
import org.jclouds.chef.strategy.CreateNodeAndPopulateAutomaticAttributes;
import org.jclouds.chef.strategy.DeleteAllClientsInList;
import org.jclouds.chef.strategy.DeleteAllNodesInList;
import org.jclouds.chef.strategy.ListClients;
import org.jclouds.chef.strategy.ListCookbookVersions;
import org.jclouds.chef.strategy.ListEnvironments;
import org.jclouds.chef.strategy.ListNodes;
import org.jclouds.chef.strategy.UpdateAutomaticAttributesOnNode;
import org.jclouds.domain.JsonBall;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.RSADecryptingPayload;
import org.jclouds.io.payloads.RSAEncryptingPayload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.Json;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.Statement;

@Singleton
public class BaseChefService
implements ChefService {
    private final ChefContext chefContext;
    private final ChefApi api;
    private final CleanupStaleNodesAndClients cleanupStaleNodesAndClients;
    private final CreateNodeAndPopulateAutomaticAttributes createNodeAndPopulateAutomaticAttributes;
    private final DeleteAllNodesInList deleteAllNodesInList;
    private final ListNodes listNodes;
    private final DeleteAllClientsInList deleteAllClientsInList;
    private final ListClients listClients;
    private final UpdateAutomaticAttributesOnNode updateAutomaticAttributesOnNode;
    private final Supplier<PrivateKey> privateKey;
    private final GroupToBootScript groupToBootScript;
    private final String databag;
    private final BootstrapConfigForGroup bootstrapConfigForGroup;
    private final RunListForGroup runListForGroup;
    private final ListCookbookVersions listCookbookVersions;
    private final ListEnvironments listEnvironments;
    private final Json json;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    protected BaseChefService(ChefContext chefContext, ChefApi api, CleanupStaleNodesAndClients cleanupStaleNodesAndClients, CreateNodeAndPopulateAutomaticAttributes createNodeAndPopulateAutomaticAttributes, DeleteAllNodesInList deleteAllNodesInList, ListNodes listNodes, DeleteAllClientsInList deleteAllClientsInList, ListClients listClients, ListCookbookVersions listCookbookVersions, UpdateAutomaticAttributesOnNode updateAutomaticAttributesOnNode, Supplier<PrivateKey> privateKey, @Named(value="chef.bootstrap-databag") String databag, GroupToBootScript groupToBootScript, BootstrapConfigForGroup bootstrapConfigForGroup, RunListForGroup runListForGroup, ListEnvironments listEnvironments, Json json) {
        this.chefContext = (ChefContext)Preconditions.checkNotNull((Object)chefContext, (Object)"chefContext");
        this.api = (ChefApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.cleanupStaleNodesAndClients = (CleanupStaleNodesAndClients)Preconditions.checkNotNull((Object)cleanupStaleNodesAndClients, (Object)"cleanupStaleNodesAndClients");
        this.createNodeAndPopulateAutomaticAttributes = (CreateNodeAndPopulateAutomaticAttributes)Preconditions.checkNotNull((Object)createNodeAndPopulateAutomaticAttributes, (Object)"createNodeAndPopulateAutomaticAttributes");
        this.deleteAllNodesInList = (DeleteAllNodesInList)Preconditions.checkNotNull((Object)deleteAllNodesInList, (Object)"deleteAllNodesInList");
        this.listNodes = (ListNodes)Preconditions.checkNotNull((Object)listNodes, (Object)"listNodes");
        this.deleteAllClientsInList = (DeleteAllClientsInList)Preconditions.checkNotNull((Object)deleteAllClientsInList, (Object)"deleteAllClientsInList");
        this.listClients = (ListClients)Preconditions.checkNotNull((Object)listClients, (Object)"listClients");
        this.listCookbookVersions = (ListCookbookVersions)Preconditions.checkNotNull((Object)listCookbookVersions, (Object)"listCookbookVersions");
        this.updateAutomaticAttributesOnNode = (UpdateAutomaticAttributesOnNode)Preconditions.checkNotNull((Object)updateAutomaticAttributesOnNode, (Object)"updateAutomaticAttributesOnNode");
        this.privateKey = (Supplier)Preconditions.checkNotNull(privateKey, (Object)"privateKey");
        this.groupToBootScript = (GroupToBootScript)Preconditions.checkNotNull((Object)groupToBootScript, (Object)"groupToBootScript");
        this.databag = (String)Preconditions.checkNotNull((Object)databag, (Object)"databag");
        this.bootstrapConfigForGroup = (BootstrapConfigForGroup)Preconditions.checkNotNull((Object)bootstrapConfigForGroup, (Object)"bootstrapConfigForGroup");
        this.runListForGroup = (RunListForGroup)Preconditions.checkNotNull((Object)runListForGroup, (Object)"runListForGroup");
        this.listEnvironments = (ListEnvironments)Preconditions.checkNotNull((Object)listEnvironments, (Object)"listEnvironments");
        this.json = (Json)Preconditions.checkNotNull((Object)json, (Object)"json");
    }

    @Override
    public void cleanupStaleNodesAndClients(String prefix, int secondsStale) {
        this.cleanupStaleNodesAndClients.execute(prefix, secondsStale);
    }

    @Override
    public Node createNodeAndPopulateAutomaticAttributes(String nodeName, Iterable<String> runList) {
        return this.createNodeAndPopulateAutomaticAttributes.execute(nodeName, runList);
    }

    @Override
    public void deleteAllNodesInList(Iterable<String> names) {
        this.deleteAllNodesInList.execute(names);
    }

    @Override
    public Iterable<? extends Node> listNodes() {
        return this.listNodes.execute();
    }

    @Override
    public Iterable<? extends Node> listNodesMatching(Predicate<String> nodeNameSelector) {
        return this.listNodes.execute(nodeNameSelector);
    }

    @Override
    public Iterable<? extends Node> listNodesNamed(Iterable<String> names) {
        return this.listNodes.execute(names);
    }

    @Override
    public void deleteAllClientsInList(Iterable<String> names) {
        this.deleteAllClientsInList.execute(names);
    }

    @Override
    public Iterable<? extends Client> listClientsDetails() {
        return this.listClients.execute();
    }

    @Override
    public Iterable<? extends Client> listClientsDetailsMatching(Predicate<String> clientNameSelector) {
        return this.listClients.execute(clientNameSelector);
    }

    @Override
    public Iterable<? extends Client> listClientsNamed(Iterable<String> names) {
        return this.listClients.execute(names);
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersions() {
        return this.listCookbookVersions.execute();
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersionsMatching(Predicate<String> cookbookNameSelector) {
        return this.listCookbookVersions.execute(cookbookNameSelector);
    }

    @Override
    public Iterable<? extends CookbookVersion> listCookbookVersionsNamed(Iterable<String> names) {
        return this.listCookbookVersions.execute(names);
    }

    @Override
    public void updateAutomaticAttributesOnNode(String nodeName) {
        this.updateAutomaticAttributesOnNode.execute(nodeName);
    }

    @Override
    public ChefContext getContext() {
        return this.chefContext;
    }

    @Override
    public Statement createBootstrapScriptForGroup(String group) {
        return this.groupToBootScript.apply(group);
    }

    @Override
    @Deprecated
    public void updateRunListForGroup(Iterable<String> runList, String group) {
        this.updateBootstrapConfigForGroup(runList, group);
    }

    @Override
    public void updateBootstrapConfigForGroup(Iterable<String> runList, String group) {
        this.updateBootstrapConfigForGroup(runList, null, group);
    }

    @Override
    public void updateBootstrapConfigForGroup(Iterable<String> runList, @Nullable JsonBall jsonAttributes, String group) {
        try {
            this.api.createDatabag(this.databag);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        String bootstrapConfig = this.buildBootstrapConfiguration(runList, (Optional<JsonBall>)Optional.fromNullable((Object)jsonAttributes));
        DatabagItem runlist = new DatabagItem(group, bootstrapConfig);
        if (this.api.getDatabagItem(this.databag, group) == null) {
            this.api.createDatabagItem(this.databag, runlist);
        } else {
            this.api.updateDatabagItem(this.databag, runlist);
        }
    }

    @Override
    public List<String> getRunListForGroup(String group) {
        return this.runListForGroup.apply(group);
    }

    @Override
    public JsonBall getBootstrapConfigForGroup(String group) {
        return this.bootstrapConfigForGroup.apply(group);
    }

    @Override
    public byte[] decrypt(InputSupplier<? extends InputStream> supplier) throws IOException {
        return ByteStreams.toByteArray((InputSupplier)new RSADecryptingPayload(Payloads.newPayload((Object)supplier.getInput()), (Key)this.privateKey.get()));
    }

    @Override
    public byte[] encrypt(InputSupplier<? extends InputStream> supplier) throws IOException {
        return ByteStreams.toByteArray((InputSupplier)new RSAEncryptingPayload(Payloads.newPayload((Object)supplier.getInput()), (Key)this.privateKey.get()));
    }

    @VisibleForTesting
    String buildBootstrapConfiguration(Iterable<String> runList, Optional<JsonBall> jsonAttributes) {
        Preconditions.checkNotNull(runList, (Object)"runList must not be null");
        Preconditions.checkNotNull(jsonAttributes, (Object)"jsonAttributes must not be null");
        HashMap bootstrapConfig = Maps.newHashMap();
        bootstrapConfig.put("run_list", Lists.newArrayList(runList));
        if (jsonAttributes.isPresent()) {
            Map attributes = (Map)this.json.fromJson(((JsonBall)jsonAttributes.get()).toString(), BootstrapConfigForGroup.BOOTSTRAP_CONFIG_TYPE);
            bootstrapConfig.putAll(attributes);
        }
        return this.json.toJson((Object)bootstrapConfig);
    }

    @Override
    public Iterable<? extends Environment> listEnvironments() {
        return this.listEnvironments.execute();
    }

    @Override
    public Iterable<? extends Environment> listEnvironmentsMatching(Predicate<String> environmentNameSelector) {
        return this.listEnvironments.execute(environmentNameSelector);
    }

    @Override
    public Iterable<? extends Environment> listEnvironmentsNamed(Iterable<String> names) {
        return this.listEnvironments.execute(names);
    }
}

