/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.strategy.CleanupStaleNodesAndClients;
import org.jclouds.chef.strategy.DeleteAllClientsInList;
import org.jclouds.chef.strategy.DeleteAllNodesInList;
import org.jclouds.chef.strategy.ListNodes;
import org.jclouds.chef.util.ChefUtils;
import org.jclouds.domain.JsonBall;
import org.jclouds.logging.Logger;

@Singleton
public class CleanupStaleNodesAndClientsImpl
implements CleanupStaleNodesAndClients {
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;
    private final ListNodes nodeLister;
    private final DeleteAllNodesInList nodeDeleter;
    private final DeleteAllClientsInList clientDeleter;

    @Inject
    public CleanupStaleNodesAndClientsImpl(DeleteAllNodesInList nodeDeleter, DeleteAllClientsInList clientDeleter, ListNodes nodeLister) {
        this.nodeLister = (ListNodes)Preconditions.checkNotNull((Object)nodeLister, (Object)"nodeLister");
        this.nodeDeleter = (DeleteAllNodesInList)Preconditions.checkNotNull((Object)nodeDeleter, (Object)"nodeDeleter");
        this.clientDeleter = (DeleteAllClientsInList)Preconditions.checkNotNull((Object)clientDeleter, (Object)"clientDeleter");
    }

    @Override
    public void execute(final String prefix, int secondsStale) {
        final Calendar expired = Calendar.getInstance();
        expired.setTime(new Date());
        expired.add(13, -secondsStale);
        Iterable staleNodes = Iterables.filter(this.nodeLister.execute(new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith(prefix);
            }
        }), (Predicate)Predicates.and((Predicate)Predicates.notNull(), (Predicate)new Predicate<Node>(){

            public boolean apply(Node input) {
                JsonBall dateLong = input.getAutomatic().get("ohai_time");
                if (dateLong == null) {
                    return true;
                }
                Calendar nodeUpdate = Calendar.getInstance();
                nodeUpdate.setTime(ChefUtils.fromOhaiTime(dateLong));
                return expired.after(nodeUpdate);
            }
        }));
        Iterable nodeNames = Iterables.transform((Iterable)staleNodes, (Function)new Function<Node, String>(){

            public String apply(Node from) {
                return from.getName();
            }
        });
        this.nodeDeleter.execute(nodeNames);
        this.clientDeleter.execute(nodeNames);
    }
}

