/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.strategy.ListClients;
import org.jclouds.logging.Logger;

@Singleton
public class ListClientsImpl
implements ListClients {
    protected final ChefApi api;
    protected final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    ListClientsImpl(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, ChefApi api) {
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecuor");
        this.api = (ChefApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    @Override
    public Iterable<? extends Client> execute() {
        return this.execute(this.userExecutor);
    }

    @Override
    public Iterable<? extends Client> execute(Predicate<String> clientNameSelector) {
        return this.execute(this.userExecutor, clientNameSelector);
    }

    @Override
    public Iterable<? extends Client> execute(Iterable<String> toGet) {
        return this.execute(this.userExecutor, toGet);
    }

    @Override
    public Iterable<? extends Client> execute(ListeningExecutorService executor) {
        return this.execute(executor, this.api.listClients());
    }

    @Override
    public Iterable<? extends Client> execute(ListeningExecutorService executor, Predicate<String> clientNameSelector) {
        return this.execute(executor, Iterables.filter(this.api.listClients(), clientNameSelector));
    }

    @Override
    public Iterable<? extends Client> execute(final ListeningExecutorService executor, Iterable<String> toGet) {
        ListenableFuture futures = Futures.allAsList((Iterable)Iterables.transform(toGet, (Function)new Function<String, ListenableFuture<Client>>(){

            public ListenableFuture<Client> apply(final String input) {
                return executor.submit((Callable)new Callable<Client>(){

                    @Override
                    public Client call() throws Exception {
                        return ListClientsImpl.this.api.getClient(input);
                    }
                });
            }
        }));
        this.logger.trace(String.format("getting clients: %s", Joiner.on((char)',').join(toGet)), new Object[0]);
        return (Iterable)Futures.getUnchecked((Future)futures);
    }
}

