/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.strategy.ListCookbookVersions;
import org.jclouds.logging.Logger;

@Singleton
public class ListCookbookVersionsImpl
implements ListCookbookVersions {
    protected final ChefApi api;
    protected final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    ListCookbookVersionsImpl(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, ChefApi api) {
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecuor");
        this.api = (ChefApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    @Override
    public Iterable<? extends CookbookVersion> execute() {
        return this.execute(this.userExecutor);
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(Predicate<String> cookbookNameSelector) {
        return this.execute(this.userExecutor, cookbookNameSelector);
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(Iterable<String> toGet) {
        return this.execute(this.userExecutor, toGet);
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(ListeningExecutorService executor) {
        return this.execute(executor, this.api.listCookbooks());
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(ListeningExecutorService executor, Predicate<String> cookbookNameSelector) {
        return this.execute(executor, Iterables.filter(this.api.listCookbooks(), cookbookNameSelector));
    }

    @Override
    public Iterable<? extends CookbookVersion> execute(final ListeningExecutorService executor, Iterable<String> cookbookNames) {
        return Iterables.concat((Iterable)Iterables.transform(cookbookNames, (Function)new Function<String, Iterable<? extends CookbookVersion>>(){

            public Iterable<? extends CookbookVersion> apply(final String cookbook) {
                Set<String> cookbookVersions = ListCookbookVersionsImpl.this.api.getVersionsOfCookbook(cookbook);
                ListenableFuture futures = Futures.allAsList((Iterable)Iterables.transform(cookbookVersions, (Function)new Function<String, ListenableFuture<CookbookVersion>>(){

                    public ListenableFuture<CookbookVersion> apply(final String version) {
                        return executor.submit((Callable)new Callable<CookbookVersion>(){

                            @Override
                            public CookbookVersion call() throws Exception {
                                return ListCookbookVersionsImpl.this.api.getCookbook(cookbook, version);
                            }
                        });
                    }
                }));
                ListCookbookVersionsImpl.this.logger.trace(String.format("getting versions of cookbook: " + cookbook, new Object[0]), new Object[0]);
                return (Iterable)Futures.getUnchecked((Future)futures);
            }
        }));
    }
}

