/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Environment;
import org.jclouds.chef.strategy.ListEnvironments;
import org.jclouds.logging.Logger;

@Singleton
public class ListEnvironmentsImpl
implements ListEnvironments {
    protected final ChefApi api;
    protected final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    ListEnvironmentsImpl(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, ChefApi api) {
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecuor");
        this.api = (ChefApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    @Override
    public Iterable<? extends Environment> execute() {
        return this.execute(this.userExecutor);
    }

    @Override
    public Iterable<? extends Environment> execute(Predicate<String> environmentNameSelector) {
        return this.execute(this.userExecutor, environmentNameSelector);
    }

    @Override
    public Iterable<? extends Environment> execute(Iterable<String> toGet) {
        return this.execute(this.userExecutor, toGet);
    }

    @Override
    public Iterable<? extends Environment> execute(ListeningExecutorService executor) {
        return this.execute(executor, this.api.listEnvironments());
    }

    @Override
    public Iterable<? extends Environment> execute(ListeningExecutorService executor, Predicate<String> environmentNameSelector) {
        return this.execute(executor, Iterables.filter(this.api.listEnvironments(), environmentNameSelector));
    }

    @Override
    public Iterable<? extends Environment> execute(final ListeningExecutorService executor, Iterable<String> toGet) {
        ListenableFuture futures = Futures.allAsList((Iterable)Iterables.transform(toGet, (Function)new Function<String, ListenableFuture<Environment>>(){

            public ListenableFuture<Environment> apply(final String input) {
                return executor.submit((Callable)new Callable<Environment>(){

                    @Override
                    public Environment call() throws Exception {
                        return ListEnvironmentsImpl.this.api.getEnvironment(input);
                    }
                });
            }
        }));
        this.logger.trace(String.format("deleting environments: %s", Joiner.on((char)',').join(toGet)), new Object[0]);
        return (Iterable)Futures.getUnchecked((Future)futures);
    }
}

