/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.strategy.ListNodes;
import org.jclouds.logging.Logger;

@Singleton
public class ListNodesImpl
implements ListNodes {
    protected final ChefApi api;
    protected final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    ListNodesImpl(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, ChefApi api) {
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecuor");
        this.api = (ChefApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    @Override
    public Iterable<? extends Node> execute() {
        return this.execute(this.userExecutor);
    }

    @Override
    public Iterable<? extends Node> execute(Predicate<String> nodeNameSelector) {
        return this.execute(this.userExecutor, nodeNameSelector);
    }

    @Override
    public Iterable<? extends Node> execute(Iterable<String> toGet) {
        return this.execute(this.userExecutor, toGet);
    }

    @Override
    public Iterable<? extends Node> execute(ListeningExecutorService executor) {
        return this.execute(executor, this.api.listNodes());
    }

    @Override
    public Iterable<? extends Node> execute(ListeningExecutorService executor, Predicate<String> nodeNameSelector) {
        return this.execute(executor, Iterables.filter(this.api.listNodes(), nodeNameSelector));
    }

    @Override
    public Iterable<? extends Node> execute(final ListeningExecutorService executor, Iterable<String> toGet) {
        ListenableFuture futures = Futures.allAsList((Iterable)Iterables.transform(toGet, (Function)new Function<String, ListenableFuture<Node>>(){

            public ListenableFuture<Node> apply(final String input) {
                return executor.submit((Callable)new Callable<Node>(){

                    @Override
                    public Node call() throws Exception {
                        return ListNodesImpl.this.api.getNode(input);
                    }
                });
            }
        }));
        this.logger.trace(String.format("getting nodes: %s", Joiner.on((char)',').join(toGet)), new Object[0]);
        return (Iterable)Futures.getUnchecked((Future)futures);
    }
}

