/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.strategy.UpdateAutomaticAttributesOnNode;
import org.jclouds.domain.JsonBall;
import org.jclouds.logging.Logger;
import org.jclouds.ohai.Automatic;

@Singleton
public class UpdateAutomaticAttributesOnNodeImpl
implements UpdateAutomaticAttributesOnNode {
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;
    private final ChefApi chef;
    private final Supplier<Map<String, JsonBall>> automaticSupplier;

    @Inject
    public UpdateAutomaticAttributesOnNodeImpl(ChefApi chef, @Automatic Supplier<Map<String, JsonBall>> automaticSupplier) {
        this.chef = (ChefApi)Preconditions.checkNotNull((Object)chef, (Object)"chef");
        this.automaticSupplier = (Supplier)Preconditions.checkNotNull(automaticSupplier, (Object)"automaticSupplier");
    }

    @Override
    public void execute(String nodeName) {
        this.logger.trace("updating node %s", new Object[]{nodeName});
        Node node = this.chef.getNode(nodeName);
        Node mutable = new Node(node.getName(), node.getNormal(), node.getOverride(), node.getDefault(), (Map)this.automaticSupplier.get(), node.getRunList(), node.getChefEnvironment());
        this.chef.updateNode(mutable);
        this.logger.debug("updated node %s", new Object[]{nodeName});
    }
}

