/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.test;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.config.LocalBlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.domain.CookbookDefinition;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.domain.Environment;
import org.jclouds.chef.domain.Node;
import org.jclouds.chef.domain.Resource;
import org.jclouds.chef.domain.Role;
import org.jclouds.chef.domain.Sandbox;
import org.jclouds.chef.domain.SearchResult;
import org.jclouds.chef.domain.UploadSandbox;
import org.jclouds.chef.options.CreateClientOptions;
import org.jclouds.chef.options.SearchOptions;
import org.jclouds.io.Payload;
import org.jclouds.lifecycle.Closer;
import org.jclouds.util.Strings2;

public class TransientChefApi
implements ChefApi {
    private final LocalBlobStore databags;
    private final BlobToDatabagItem blobToDatabagItem;
    private final StorageMetadataToName storageMetadataToName;
    private final Closer closer;

    @Inject
    TransientChefApi(@Named(value="databags") LocalBlobStore databags, StorageMetadataToName storageMetadataToName, BlobToDatabagItem blobToDatabagItem, Closer closer) {
        this.databags = (LocalBlobStore)Preconditions.checkNotNull((Object)databags, (Object)"databags");
        this.storageMetadataToName = (StorageMetadataToName)Preconditions.checkNotNull((Object)storageMetadataToName, (Object)"storageMetadataToName");
        this.blobToDatabagItem = (BlobToDatabagItem)Preconditions.checkNotNull((Object)blobToDatabagItem, (Object)"blobToDatabagItem");
        this.closer = (Closer)Preconditions.checkNotNull((Object)closer, (Object)"closer");
    }

    @Override
    public boolean clientExists(String clientname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sandbox commitSandbox(String id, boolean isCompleted) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Client createClient(String clientname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Client createClient(String clientname, CreateClientOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createDatabag(String databagName) {
        this.databags.createContainerInLocation(null, databagName);
    }

    @Override
    public DatabagItem createDatabagItem(String databagName, DatabagItem databagItem) {
        Blob blob = this.databags.blobBuilder(databagItem.getId()).payload(databagItem.toString()).build();
        this.databags.putBlob(databagName, blob);
        return databagItem;
    }

    @Override
    public void createNode(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createRole(Role role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean databagExists(String databagName) {
        return this.databags.containerExists(databagName);
    }

    @Override
    public boolean databagItemExists(String databagName, String databagItemId) {
        return this.databags.blobExists(databagName, databagItemId);
    }

    @Override
    public Client deleteClient(String clientname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CookbookVersion deleteCookbook(String cookbookName, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteDatabag(String databagName) {
        this.databags.deleteContainer(databagName);
    }

    @Override
    public DatabagItem deleteDatabagItem(String databagName, String databagItemId) {
        DatabagItem item = this.blobToDatabagItem.apply(this.databags.getBlob(databagName, databagItemId));
        this.databags.removeBlob(databagName, databagItemId);
        return item;
    }

    @Override
    public Node deleteNode(String nodename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Role deleteRole(String rolename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Client generateKeyForClient(String clientname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Client getClient(String clientname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CookbookVersion getCookbook(String cookbookName, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DatabagItem getDatabagItem(String databagName, String databagItemId) {
        return this.blobToDatabagItem.apply(this.databags.getBlob(databagName, databagItemId));
    }

    @Override
    public Node getNode(String nodename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Role getRole(String rolename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UploadSandbox getUploadSandboxForChecksums(Set<List<Byte>> md5s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getVersionsOfCookbook(String cookbookName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> listClients() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> listCookbooks() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> listDatabagItems(String databagName) {
        return this.storageMetadataToName.apply((PageSet<? extends StorageMetadata>)this.databags.list(databagName));
    }

    @Override
    public Set<String> listDatabags() {
        return this.storageMetadataToName.apply((PageSet<? extends StorageMetadata>)this.databags.list());
    }

    @Override
    public Set<String> listNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> listRoles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> listSearchIndexes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean nodeExists(String nodename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean roleExists(String rolename) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResult<? extends Client> searchClients() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResult<? extends Client> searchClients(SearchOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResult<? extends DatabagItem> searchDatabag(String databagName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResult<? extends DatabagItem> searchDatabag(String databagName, SearchOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResult<? extends Node> searchNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResult<? extends Node> searchNodes(SearchOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResult<? extends Role> searchRoles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResult<? extends Role> searchRoles(SearchOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CookbookVersion updateCookbook(String cookbookName, String version, CookbookVersion cookbook) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DatabagItem updateDatabagItem(String databagName, DatabagItem item) {
        return this.createDatabagItem(databagName, item);
    }

    @Override
    public Node updateNode(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Role updateRole(Role role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void uploadContent(URI location, Payload content) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getResourceContents(Resource resource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> listEnvironments() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createEnvironment(Environment environment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Environment deleteEnvironment(String environmentname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Environment getEnvironment(String environmentname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Environment updateEnvironment(Environment environment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<CookbookDefinition> listEnvironmentCookbooks(String environmentname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<CookbookDefinition> listEnvironmentCookbooks(String environmentname, String numversions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CookbookDefinition getEnvironmentCookbook(String environmentname, String cookbookname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CookbookDefinition getEnvironmentCookbook(String environmentname, String cookbookname, String numversions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResult<? extends Environment> searchEnvironments() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResult<? extends Environment> searchEnvironments(SearchOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    @Singleton
    private static class BlobToDatabagItem
    implements Function<Blob, DatabagItem> {
        private BlobToDatabagItem() {
        }

        public DatabagItem apply(Blob from) {
            try {
                return from == null ? null : new DatabagItem(from.getMetadata().getName(), Strings2.toStringAndClose((InputStream)from.getPayload().getInput()));
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    @Singleton
    private static class StorageMetadataToName
    implements Function<PageSet<? extends StorageMetadata>, Set<String>> {
        private StorageMetadataToName() {
        }

        public Set<String> apply(PageSet<? extends StorageMetadata> from) {
            return Sets.newLinkedHashSet((Iterable)Iterables.transform(from, (Function)new Function<StorageMetadata, String>(){

                public String apply(StorageMetadata from) {
                    return from.getName();
                }
            }));
        }
    }
}

