/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.test.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import javax.inject.Singleton;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.TransientApiMetadata;
import org.jclouds.blobstore.config.LocalBlobStore;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.config.Validator;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.functions.BootstrapConfigForGroup;
import org.jclouds.chef.functions.ClientForGroup;
import org.jclouds.chef.functions.RunListForGroup;
import org.jclouds.chef.test.TransientChefApi;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.crypto.Crypto;
import org.jclouds.domain.JsonBall;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.RestModule;
import org.jclouds.rest.config.SyncToAsyncHttpInvocationModule;

@ConfiguresHttpApi
public class TransientChefApiModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new RestModule());
        this.install((Module)new SyncToAsyncHttpInvocationModule());
        this.bind(ChefApi.class).to(TransientChefApi.class);
        this.bind(LocalBlobStore.class).annotatedWith((Annotation)Names.named((String)"databags")).toInstance(ContextBuilder.newBuilder((ApiMetadata)new TransientApiMetadata()).modules((Iterable)ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()))).buildInjector().getInstance(LocalBlobStore.class));
    }

    @Provides
    @Singleton
    public Supplier<PrivateKey> supplyKey() {
        return new Supplier<PrivateKey>(){

            public PrivateKey get() {
                return null;
            }
        };
    }

    @Provides
    @Singleton
    CacheLoader<String, List<String>> runListForGroup(RunListForGroup runListForGroup) {
        return CacheLoader.from((Function)runListForGroup);
    }

    @Provides
    @Singleton
    CacheLoader<String, ? extends JsonBall> bootstrapConfigForGroup(BootstrapConfigForGroup bootstrapConfigForGroup) {
        return CacheLoader.from((Function)bootstrapConfigForGroup);
    }

    @Provides
    @Singleton
    CacheLoader<String, Client> groupToClient(ClientForGroup clientForGroup) {
        return CacheLoader.from((Function)clientForGroup);
    }

    @Provides
    @Singleton
    @Validator
    public Optional<String> provideValidatorName(Injector injector) {
        return Optional.absent();
    }

    @Provides
    @Singleton
    @Validator
    public Optional<PrivateKey> provideValidatorCredential(Crypto crypto, Injector injector) throws InvalidKeySpecException, IOException {
        return Optional.absent();
    }
}

