/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ohai.config.multibindings;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.name.Names;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.Message;
import com.google.inject.spi.Toolable;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jclouds.ohai.config.multibindings.Element;
import org.jclouds.ohai.config.multibindings.RealElement;

public abstract class Multibinder<T> {
    private Multibinder() {
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type) {
        binder = binder.skipSources(new Class[]{RealMultibinder.class, Multibinder.class});
        RealMultibinder result = new RealMultibinder(binder, type, "", Key.get(Multibinder.setOf(type)));
        binder.install(result);
        return result;
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type) {
        return Multibinder.newSetBinder(binder, TypeLiteral.get(type));
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type, Annotation annotation) {
        binder = binder.skipSources(new Class[]{RealMultibinder.class, Multibinder.class});
        RealMultibinder result = new RealMultibinder(binder, type, ((Object)annotation).toString(), Key.get(Multibinder.setOf(type), (Annotation)annotation));
        binder.install(result);
        return result;
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type, Annotation annotation) {
        return Multibinder.newSetBinder(binder, TypeLiteral.get(type), annotation);
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, TypeLiteral<T> type, Class<? extends Annotation> annotationType) {
        binder = binder.skipSources(new Class[]{RealMultibinder.class, Multibinder.class});
        RealMultibinder result = new RealMultibinder(binder, type, "@" + annotationType.getName(), Key.get(Multibinder.setOf(type), annotationType));
        binder.install(result);
        return result;
    }

    public static <T> Multibinder<T> newSetBinder(Binder binder, Class<T> type, Class<? extends Annotation> annotationType) {
        return Multibinder.newSetBinder(binder, TypeLiteral.get(type), annotationType);
    }

    static <T> TypeLiteral<Set<T>> setOf(TypeLiteral<T> elementType) {
        ParameterizedType type = Types.setOf((Type)elementType.getType());
        return TypeLiteral.get((Type)type);
    }

    public abstract Multibinder<T> permitDuplicates();

    public abstract LinkedBindingBuilder<T> addBinding();

    static void checkConfiguration(boolean condition, String format, Object ... args) {
        if (condition) {
            return;
        }
        throw new ConfigurationException((Iterable)ImmutableSet.of((Object)new Message(String.format(format, args))));
    }

    static <T> T checkNotNull(T reference, String name) {
        if (reference != null) {
            return reference;
        }
        NullPointerException npe = new NullPointerException(name);
        throw new ConfigurationException((Iterable)ImmutableSet.of((Object)new Message((List)ImmutableList.of(), npe.toString(), (Throwable)npe)));
    }

    private static class PermitDuplicatesModule
    extends AbstractModule {
        private final Key<Boolean> key;

        PermitDuplicatesModule(Key<Boolean> key) {
            this.key = key;
        }

        protected void configure() {
            this.bind(this.key).toInstance((Object)true);
        }

        public boolean equals(Object o) {
            return o instanceof PermitDuplicatesModule && ((PermitDuplicatesModule)((Object)o)).key.equals(this.key);
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode() ^ this.key.hashCode();
        }
    }

    static final class RealMultibinder<T>
    extends Multibinder<T>
    implements Module,
    Provider<Set<T>>,
    HasDependencies {
        private final TypeLiteral<T> elementType;
        private final String setName;
        private final Key<Set<T>> setKey;
        private final Key<Boolean> permitDuplicatesKey;
        private Binder binder;
        private List<Provider<T>> providers;
        private Set<Dependency<?>> dependencies;
        private boolean permitDuplicates;

        private RealMultibinder(Binder binder, TypeLiteral<T> elementType, String setName, Key<Set<T>> setKey) {
            this.binder = RealMultibinder.checkNotNull(binder, "binder");
            this.elementType = RealMultibinder.checkNotNull(elementType, "elementType");
            this.setName = RealMultibinder.checkNotNull(setName, "setName");
            this.setKey = RealMultibinder.checkNotNull(setKey, "setKey");
            this.permitDuplicatesKey = Key.get(Boolean.class, (Annotation)Names.named((String)(this.toString() + " permits duplicates")));
        }

        public void configure(Binder binder) {
            RealMultibinder.checkConfiguration(!this.isInitialized(), "Multibinder was already initialized", new Object[0]);
            binder.bind(this.setKey).toProvider((Provider)this);
        }

        @Override
        public Multibinder<T> permitDuplicates() {
            this.binder.install((Module)new PermitDuplicatesModule(this.permitDuplicatesKey));
            return this;
        }

        @Override
        public LinkedBindingBuilder<T> addBinding() {
            RealMultibinder.checkConfiguration(!this.isInitialized(), "Multibinder was already initialized", new Object[0]);
            return this.binder.bind(Key.get(this.elementType, (Annotation)new RealElement(this.setName)));
        }

        @Toolable
        @Inject
        void initialize(Injector injector) {
            this.providers = Lists.newArrayList();
            ArrayList dependencies = Lists.newArrayList();
            for (Binding entry : injector.findBindingsByType(this.elementType)) {
                if (!this.keyMatches(entry.getKey())) continue;
                Binding binding = entry;
                this.providers.add(binding.getProvider());
                dependencies.add(Dependency.get((Key)binding.getKey()));
            }
            this.dependencies = ImmutableSet.copyOf((Collection)dependencies);
            this.permitDuplicates = this.permitsDuplicates(injector);
            this.binder = null;
        }

        boolean permitsDuplicates(Injector injector) {
            return injector.getBindings().containsKey(this.permitDuplicatesKey);
        }

        private boolean keyMatches(Key<?> key) {
            return key.getTypeLiteral().equals(this.elementType) && key.getAnnotation() instanceof Element && ((Element)key.getAnnotation()).setName().equals(this.setName);
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        public Set<T> get() {
            RealMultibinder.checkConfiguration(this.isInitialized(), "Multibinder is not initialized", new Object[0]);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            for (Provider<T> provider : this.providers) {
                Object newValue = provider.get();
                RealMultibinder.checkConfiguration(newValue != null, "Set injection failed due to null element", new Object[0]);
                RealMultibinder.checkConfiguration(result.add(newValue) || this.permitDuplicates, "Set injection failed due to duplicated element \"%s\"", newValue);
            }
            return Collections.unmodifiableSet(result);
        }

        String getSetName() {
            return this.setName;
        }

        Key<Set<T>> getSetKey() {
            return this.setKey;
        }

        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(Object o) {
            return o instanceof RealMultibinder && ((RealMultibinder)o).setKey.equals(this.setKey);
        }

        public int hashCode() {
            return this.setKey.hashCode();
        }

        public String toString() {
            return this.setName + (this.setName.length() > 0 ? " " : "") + "Multibinder<" + this.elementType + ">";
        }
    }
}

