/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import java.net.URI;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.cloudfiles.CDNManagement;
import org.jclouds.cloudfiles.CloudFilesAsyncClient;
import org.jclouds.cloudfiles.CloudFilesClient;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.keystone.v1_1.config.AuthenticationServiceModule;
import org.jclouds.openstack.keystone.v1_1.suppliers.V1DefaultRegionIdSupplier;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.Storage;
import org.jclouds.openstack.swift.config.SwiftRestClientModule;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresRestClient;

@ConfiguresRestClient
public class CloudFilesRestClientModule
extends SwiftRestClientModule<CloudFilesClient, CloudFilesAsyncClient> {
    public CloudFilesRestClientModule() {
        super(Reflection2.typeToken(CloudFilesClient.class), Reflection2.typeToken(CloudFilesAsyncClient.class), (Map)ImmutableMap.of());
    }

    protected void bindResolvedClientsToCommonSwift() {
        this.bind(CommonSwiftClient.class).to(CloudFilesClient.class).in(Scopes.SINGLETON);
        this.bind(CommonSwiftAsyncClient.class).to(CloudFilesAsyncClient.class).in(Scopes.SINGLETON);
    }

    @VisibleForTesting
    static <K, V> Supplier<V> valueForKey(final Supplier<Map<K, Supplier<V>>> input, final Supplier<K> key) {
        return new Supplier<V>(){

            public V get() {
                Object keyToFind = key.get();
                Supplier value = (Supplier)((Map)input.get()).get(keyToFind);
                return value != null ? value.get() : null;
            }

            public String toString() {
                return "withKey()";
            }
        };
    }

    public static class StorageAndCDNManagementEndpointModule
    extends AuthenticationServiceModule {
        @Provides
        @Singleton
        @CDNManagement
        protected Supplier<URI> provideCDNUrl(RegionIdToURISupplier.Factory factory, V1DefaultRegionIdSupplier.Factory defaultRegion) {
            return CloudFilesRestClientModule.valueForKey(factory.createForApiTypeAndVersion("cloudFilesCDN", null), defaultRegion.createForApiType("cloudFilesCDN"));
        }

        @Provides
        @Singleton
        @Storage
        protected Supplier<URI> provideStorageUrl(RegionIdToURISupplier.Factory factory, V1DefaultRegionIdSupplier.Factory defaultRegion) {
            return CloudFilesRestClientModule.valueForKey(factory.createForApiTypeAndVersion("cloudFiles", null), defaultRegion.createForApiType("cloudFiles"));
        }
    }
}

