/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.jclouds.cloudfiles.domain.ContainerCDNMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;

public class ParseContainerCDNMetadataFromHeaders
implements Function<HttpResponse, ContainerCDNMetadata>,
InvocationContext<ParseContainerCDNMetadataFromHeaders> {
    private HttpRequest request;

    public ContainerCDNMetadata apply(HttpResponse from) {
        String cdnEnabled = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-CDN-Enabled"), (Object)"X-CDN-Enabled");
        String cdnLogRetention = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Log-Retention"), (Object)"X-Log-Retention");
        String cdnTTL = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-TTL"), (Object)"X-TTL");
        String cdnUri = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-CDN-URI"), (Object)"X-CDN-URI");
        String cdnSslUri = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Cdn-Ssl-Uri"), (Object)"X-Cdn-Ssl-Uri");
        String cdnStreamingUri = (String)Preconditions.checkNotNull((Object)from.getFirstHeaderOrNull("X-Cdn-Streaming-Uri"), (Object)"X-Cdn-Streaming-Uri");
        if (cdnUri == null) {
            return null;
        }
        return new ContainerCDNMetadata(this.request.getEndpoint().getPath(), Boolean.parseBoolean(cdnEnabled), Boolean.parseBoolean(cdnLogRetention), Long.parseLong(cdnTTL), URI.create(cdnUri), URI.create(cdnSslUri), URI.create(cdnStreamingUri));
    }

    public ParseContainerCDNMetadataFromHeaders setContext(HttpRequest request) {
        this.request = request;
        return this;
    }
}

