/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.features;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.domain.Alarm;
import org.jclouds.cloudwatch.domain.AlarmHistoryItem;
import org.jclouds.cloudwatch.domain.ComparisonOperator;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.MetricDatum;
import org.jclouds.cloudwatch.domain.StatisticValues;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.cloudwatch.features.AlarmApi;
import org.jclouds.cloudwatch.features.MetricApi;
import org.jclouds.cloudwatch.internal.BaseCloudWatchApiLiveTest;
import org.jclouds.cloudwatch.options.ListAlarmHistoryOptions;
import org.jclouds.cloudwatch.options.ListAlarmsForMetric;
import org.jclouds.cloudwatch.options.ListAlarmsOptions;
import org.jclouds.cloudwatch.options.ListMetricsOptions;
import org.jclouds.cloudwatch.options.SaveAlarmOptions;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="AlarmApiLiveTest")
public class AlarmApiLiveTest
extends BaseCloudWatchApiLiveTest {
    private String alarmName = "TestAlarmName" + System.currentTimeMillis();
    private String metricName = "TestMetricForAlarms";
    private String namespace = "JCLOUDS/Test";

    @BeforeClass
    protected void beforeClass() throws Exception {
        IterableWithMarker metrics = this.metricApi().list(new ListMetricsOptions().metricName(this.metricName));
        if (Iterables.size((Iterable)metrics) == 0) {
            this.metricApi().putMetricsInNamespace((Iterable)ImmutableSet.of((Object)MetricDatum.builder().metricName(this.metricName).statisticValues(StatisticValues.builder().maximum(4.0).minimum(1.0).sampleCount(4.0).sum(10.0).build()).dimension(new Dimension("BaseMetricName", this.metricName)).dimension(new Dimension("TestDimension2", "TEST2")).unit(Unit.COUNT).timestamp(new Date()).build()), this.namespace);
            ListMetricsOptions lmo = ListMetricsOptions.Builder.namespace((String)this.namespace).metricName(this.metricName);
            boolean success = Predicates2.retry((Predicate)new Predicate<ListMetricsOptions>(){

                public boolean apply(ListMetricsOptions options) {
                    return Iterables.size((Iterable)AlarmApiLiveTest.this.metricApi().list(options)) == 1;
                }
            }, (long)5L, (long)1L, (TimeUnit)TimeUnit.MINUTES).apply((Object)lmo);
            if (!success) {
                Assert.fail((String)"Unable to create the test CloudWatch metric within the time (5m) allotted.");
            }
        }
    }

    @AfterClass
    protected void afterClass() throws Exception {
        IterableWithMarker alarms = (IterableWithMarker)this.api().list(new ListAlarmsOptions().alarmName(this.alarmName)).get(0);
        if (Iterables.size((Iterable)alarms) > 0) {
            this.api().delete((Iterable)ImmutableSet.of((Object)this.alarmName));
        }
    }

    @Test
    protected void testAlarmCRUD() throws Exception {
        this.api().save(new SaveAlarmOptions().actionsEnabled(true).alarmDescription("This is a test alarm for jclouds.").alarmName(this.alarmName).comparisonOperator(ComparisonOperator.GREATER_THAN_THRESHOLD).evaluationPeriods(5).metricName(this.metricName).namespace(this.namespace).period(60).statistic(Statistics.SAMPLE_COUNT).threshold(1.0));
        ListAlarmsOptions dmo = new ListAlarmsOptions().alarmName(this.alarmName);
        boolean success = Predicates2.retry((Predicate)new Predicate<ListAlarmsOptions>(){

            public boolean apply(ListAlarmsOptions options) {
                return Iterables.size((Iterable)((Iterable)AlarmApiLiveTest.this.api().list(options).get(0))) == 1;
            }
        }, (long)5L, (long)1L, (TimeUnit)TimeUnit.MINUTES).apply((Object)dmo);
        if (!success) {
            Assert.fail((String)"Unable to create the test CloudWatch alarm within the time (5m) allotted.");
        }
        if (!(success = Predicates2.retry((Predicate)new Predicate<Void>(){

            public boolean apply(Void arg) {
                for (IterableWithMarker page : AlarmApiLiveTest.this.api().list()) {
                    for (Alarm alarm : page) {
                        if (!alarm.getAlarmName().equals(AlarmApiLiveTest.this.alarmName)) continue;
                        return true;
                    }
                }
                return false;
            }
        }, (long)5L, (long)1L, (TimeUnit)TimeUnit.MINUTES).apply(null))) {
            Assert.fail((String)"Unable to create the test CloudWatch alarm within the time (5m) allotted.");
        }
        ListAlarmsForMetric dafmo = new ListAlarmsForMetric().metricName(this.metricName).namespace(this.namespace);
        success = Predicates2.retry((Predicate)new Predicate<ListAlarmsForMetric>(){

            public boolean apply(ListAlarmsForMetric options) {
                for (Alarm alarm : AlarmApiLiveTest.this.api().listForMetric(options)) {
                    if (!alarm.getAlarmName().equals(AlarmApiLiveTest.this.alarmName)) continue;
                    return true;
                }
                return false;
            }
        }, (long)5L, (long)1L, (TimeUnit)TimeUnit.MINUTES).apply((Object)dafmo);
        if (!success) {
            Assert.fail((String)"Unable to create the test CloudWatch alarm history item within the time (5m) allotted.");
        }
        this.api().setState(this.alarmName, "Updating the state.", null, Alarm.State.OK);
        ListAlarmHistoryOptions daho = new ListAlarmHistoryOptions().alarmName(this.alarmName);
        success = Predicates2.retry((Predicate)new Predicate<ListAlarmHistoryOptions>(){

            public boolean apply(ListAlarmHistoryOptions options) {
                for (IterableWithMarker page : AlarmApiLiveTest.this.api().listHistory(options)) {
                    for (AlarmHistoryItem alarmHistoryItem : page) {
                        JsonObject historyData;
                        if (!alarmHistoryItem.getAlarmName().equals(AlarmApiLiveTest.this.alarmName) || !(historyData = new JsonParser().parse(alarmHistoryItem.getHistoryData()).getAsJsonObject()).has("newState") || !historyData.getAsJsonObject("newState").has("stateReason") || !historyData.getAsJsonObject("newState").get("stateReason").getAsString().equals("Updating the state.")) continue;
                        return true;
                    }
                }
                return false;
            }
        }, (long)5L, (long)1L, (TimeUnit)TimeUnit.MINUTES).apply((Object)daho);
        if (!success) {
            Assert.fail((String)"Unable to create the test CloudWatch alarm history item within the time (5m) allotted.");
        }
        if (!(success = Predicates2.retry((Predicate)new Predicate<Void>(){

            public boolean apply(Void arg) {
                for (IterableWithMarker page : AlarmApiLiveTest.this.api().listHistory()) {
                    for (AlarmHistoryItem alarmHistoryItem : page) {
                        JsonObject historyData;
                        if (!alarmHistoryItem.getAlarmName().equals(AlarmApiLiveTest.this.alarmName) || !(historyData = new JsonParser().parse(alarmHistoryItem.getHistoryData()).getAsJsonObject()).has("newState") || !historyData.getAsJsonObject("newState").has("stateReason") || !historyData.getAsJsonObject("newState").get("stateReason").getAsString().equals("Updating the state.")) continue;
                        return true;
                    }
                }
                return false;
            }
        }, (long)5L, (long)1L, (TimeUnit)TimeUnit.MINUTES).apply(null))) {
            Assert.fail((String)"Unable to create the test CloudWatch alarm history item within the time (5m) allotted.");
        }
        this.api().disable((Iterable)ImmutableSet.of((Object)this.alarmName));
        success = Predicates2.retry((Predicate)new Predicate<ListAlarmsOptions>(){

            public boolean apply(ListAlarmsOptions options) {
                Iterable alarms = (Iterable)AlarmApiLiveTest.this.api().list(options).get(0);
                return Iterables.size((Iterable)alarms) == 1 && !((Alarm)alarms.iterator().next()).areActionsEnabled();
            }
        }, (long)5L, (long)1L, (TimeUnit)TimeUnit.MINUTES).apply((Object)dmo);
        if (!success) {
            Assert.fail((String)"Unable to validate the test CloudWatch alarm disablement within the time (5m) allotted.");
        }
        this.api().enable((Iterable)ImmutableSet.of((Object)this.alarmName));
        success = Predicates2.retry((Predicate)new Predicate<ListAlarmsOptions>(){

            public boolean apply(ListAlarmsOptions options) {
                IterableWithMarker alarms = (IterableWithMarker)AlarmApiLiveTest.this.api().list(options).get(0);
                return Iterables.size((Iterable)alarms) == 1 && ((Alarm)alarms.iterator().next()).areActionsEnabled();
            }
        }, (long)5L, (long)1L, (TimeUnit)TimeUnit.MINUTES).apply((Object)dmo);
        if (!success) {
            Assert.fail((String)"Unable to validate the test CloudWatch alarm enablement within the time (5m) allotted.");
        }
        this.api().delete((Iterable)ImmutableSet.of((Object)this.alarmName));
        success = Predicates2.retry((Predicate)new Predicate<ListAlarmsOptions>(){

            public boolean apply(ListAlarmsOptions options) {
                return Iterables.size((Iterable)((Iterable)AlarmApiLiveTest.this.api().list(options).get(0))) == 0;
            }
        }, (long)5L, (long)1L, (TimeUnit)TimeUnit.MINUTES).apply((Object)dmo);
        if (!success) {
            Assert.fail((String)"Unable to delete the test CloudWatch alarm within the time (5m) allotted.");
        }
    }

    protected AlarmApi api() {
        return ((CloudWatchApi)this.api).getAlarmApiForRegion(null);
    }

    protected MetricApi metricApi() {
        return ((CloudWatchApi)this.api).getMetricApiForRegion(null);
    }
}

