/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.cloudwatch.domain.HistoryItemType;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.options.BaseHttpRequestOptions;

@Beta
public class ListAlarmHistoryOptions
extends BaseHttpRequestOptions {
    private static final DateService dateService = new SimpleDateFormatDateService();

    public ListAlarmHistoryOptions alarmName(String alarmName) {
        Preconditions.checkNotNull((Object)alarmName, (Object)"alarmName");
        Preconditions.checkArgument((alarmName.length() <= 255 ? 1 : 0) != 0, (Object)"alarmName must be between 1 and 255 characters in length");
        this.formParameters.put((Object)"AlarmName", (Object)alarmName);
        return this;
    }

    public ListAlarmHistoryOptions endDate(Date endDate) {
        this.formParameters.put((Object)"EndDate", (Object)dateService.iso8601DateFormat((Date)Preconditions.checkNotNull((Object)endDate, (Object)"endDate")));
        return this;
    }

    public ListAlarmHistoryOptions historyItemType(HistoryItemType historyItemType) {
        Preconditions.checkNotNull((Object)((Object)historyItemType), (Object)"historyItemType");
        Preconditions.checkArgument((historyItemType != HistoryItemType.UNRECOGNIZED ? 1 : 0) != 0, (Object)"historyItemType unrecognized");
        this.formParameters.put((Object)"HistoryItemType", (Object)historyItemType.toString());
        return this;
    }

    public ListAlarmHistoryOptions maxRecords(int maxRecords) {
        this.formParameters.put((Object)"MaxRecords", (Object)((Integer)Preconditions.checkNotNull((Object)maxRecords, (Object)"maxRecords")).toString());
        return this;
    }

    public ListAlarmHistoryOptions startDate(Date startDate) {
        this.formParameters.put((Object)"StartDate", (Object)dateService.iso8601DateFormat((Date)Preconditions.checkNotNull((Object)startDate, (Object)"startDate")));
        return this;
    }
}

