/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.Provider;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.KeystoneAsyncApi;
import org.jclouds.openstack.keystone.v2_0.features.ServiceApi;
import org.jclouds.openstack.keystone.v2_0.features.ServiceAsyncApi;
import org.jclouds.openstack.keystone.v2_0.features.TenantApi;
import org.jclouds.openstack.keystone.v2_0.features.TenantAsyncApi;
import org.jclouds.openstack.keystone.v2_0.features.TokenApi;
import org.jclouds.openstack.keystone.v2_0.features.TokenAsyncApi;
import org.jclouds.openstack.keystone.v2_0.features.UserApi;
import org.jclouds.openstack.keystone.v2_0.features.UserAsyncApi;
import org.jclouds.openstack.keystone.v2_0.handlers.KeystoneErrorHandler;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURIFromAccessForTypeAndVersion;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURISupplier;
import org.jclouds.openstack.v2_0.domain.Extension;
import org.jclouds.openstack.v2_0.features.ExtensionApi;
import org.jclouds.openstack.v2_0.features.ExtensionAsyncApi;
import org.jclouds.openstack.v2_0.functions.PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.functions.ImplicitOptionalConverter;
import org.jclouds.util.Suppliers2;

@ConfiguresRestClient
public class KeystoneRestClientModule<S extends KeystoneApi, A extends KeystoneAsyncApi>
extends RestClientModule<S, A> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(ServiceApi.class, ServiceAsyncApi.class).put(ExtensionApi.class, ExtensionAsyncApi.class).put(TokenApi.class, TokenAsyncApi.class).put(UserApi.class, UserAsyncApi.class).put(TenantApi.class, TenantAsyncApi.class).build();

    public KeystoneRestClientModule() {
        super((TypeToken)TypeToken.class.cast(Reflection2.typeToken(KeystoneApi.class)), (TypeToken)TypeToken.class.cast(Reflection2.typeToken(KeystoneAsyncApi.class)), DELEGATE_MAP);
    }

    protected KeystoneRestClientModule(TypeToken<S> syncApiType, TypeToken<A> asyncApiType, Map<Class<?>, Class<?>> sync2Async) {
        super(syncApiType, asyncApiType, sync2Async);
    }

    protected void configure() {
        this.bind(ImplicitOptionalConverter.class).to(PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet.class);
        super.configure();
    }

    @Provides
    @Singleton
    public Multimap<URI, URI> aliases() {
        return ImmutableMultimap.builder().build();
    }

    @Provides
    @Singleton
    public LoadingCache<String, Set<? extends Extension>> provideExtensionsByZone(final javax.inject.Provider<KeystoneApi> keystoneApi) {
        return CacheBuilder.newBuilder().expireAfterWrite(23L, TimeUnit.HOURS).build(CacheLoader.from((Supplier)Suppliers.memoize((Supplier)new Supplier<Set<? extends Extension>>(){

            public Set<? extends Extension> get() {
                return ((KeystoneApi)keystoneApi.get()).getExtensionApi().list();
            }
        })));
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(KeystoneErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(KeystoneErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(KeystoneErrorHandler.class);
    }

    public static class KeystoneAdminURLModule
    extends AbstractModule {
        protected void configure() {
            this.install(new FactoryModuleBuilder().implement(RegionIdToAdminURISupplier.class, RegionIdToAdminURIFromAccessForTypeAndVersion.class).build(RegionIdToAdminURISupplier.Factory.class));
        }

        @Provides
        @Singleton
        @Identity
        protected Supplier<URI> provideStorageUrl(RegionIdToAdminURISupplier.Factory factory, @ApiVersion String version, @Provider Supplier<URI> providerURI) {
            Supplier identityServiceForVersion = Suppliers2.getLastValueInMap((Supplier)factory.createForApiTypeAndVersion("identity", version));
            Supplier whenIdentityServiceIsntListedFallbackToProviderURI = Suppliers2.onThrowable((Supplier)identityServiceForVersion, NoSuchElementException.class, providerURI);
            Supplier whenIdentityServiceHasNoAdminURLFallbackToProviderURI = Suppliers2.or((Supplier)whenIdentityServiceIsntListedFallbackToProviderURI, providerURI);
            return whenIdentityServiceHasNoAdminURLFallbackToProviderURI;
        }
    }
}

