/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.Role;

public class User
extends ForwardingSet<Role> {
    private final String id;
    private final String name;
    private final Set<Role> roles;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromUser(this);
    }

    @ConstructorProperties(value={"id", "name", "roles"})
    protected User(String id, String name, @Nullable Set<Role> roles) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.roles = roles == null ? ImmutableSet.of() : ImmutableSet.copyOf(roles);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.roles});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        User that = (User)((Object)User.class.cast(obj));
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.roles, that.roles);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)((Object)this)).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("roles", this.roles);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Set<Role> delegate() {
        return this.roles;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected ImmutableSet.Builder<Role> roles = ImmutableSet.builder();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T role(Role role) {
            this.roles.add((Object)role);
            return this.self();
        }

        public T roles(Iterable<Role> roles) {
            this.roles.addAll(roles);
            return this.self();
        }

        public User build() {
            return new User(this.id, this.name, (Set<Role>)this.roles.build());
        }

        public T fromUser(User in) {
            return ((Builder)((Builder)this.id(in.getId())).name(in.getName())).roles((Iterable<Role>)((Object)in));
        }
    }
}

