/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.functions.internal.ParseTenants;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@Endpoint(value=Identity.class)
public interface TenantAsyncApi {
    @Named(value="tenant:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/tenants")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseTenants.class)
    @Transform(value=ParseTenants.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<? extends Tenant>> list();

    @Named(value="tenant:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/tenants")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseTenants.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public ListenableFuture<? extends PaginatedCollection<? extends Tenant>> list(PaginationOptions var1);

    @Named(value="tenant:get")
    @GET
    @SelectJson(value={"tenant"})
    @Consumes(value={"application/json"})
    @Path(value="/tenants/{tenantId}")
    @RequestFilters(value={AuthenticateRequest.class})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends Tenant> get(@PathParam(value="tenantId") String var1);

    @Named(value="tenant:get")
    @GET
    @SelectJson(value={"tenant"})
    @Consumes(value={"application/json"})
    @Path(value="/tenants")
    @RequestFilters(value={AuthenticateRequest.class})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends Tenant> getByName(@QueryParam(value="name") String var1);
}

