/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.functions.internal.ParseUsers;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;

@Endpoint(value=Identity.class)
public interface UserAsyncApi {
    @Named(value="user:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/users")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseUsers.class)
    @Transform(value=ParseUsers.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<? extends User>> list();

    @Named(value="user:list")
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/users")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseUsers.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    public ListenableFuture<? extends PaginatedCollection<? extends User>> list(PaginationOptions var1);

    @Named(value="user:get")
    @GET
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @Path(value="/users/{userId}")
    @RequestFilters(value={AuthenticateRequest.class})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends User> get(@PathParam(value="userId") String var1);

    @Named(value="user:get")
    @GET
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @Path(value="/users")
    @RequestFilters(value={AuthenticateRequest.class})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends User> getByName(@QueryParam(value="name") String var1);

    @Named(value="user:listroles")
    @GET
    @SelectJson(value={"roles"})
    @Consumes(value={"application/json"})
    @Path(value="/users/{userId}/roles")
    @RequestFilters(value={AuthenticateRequest.class})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<? extends Role>> listRolesOfUser(@PathParam(value="userId") String var1);

    @Named(value="user:listroles")
    @GET
    @SelectJson(value={"roles"})
    @Consumes(value={"application/json"})
    @Path(value="/tenants/{tenantId}/users/{userId}/roles")
    @RequestFilters(value={AuthenticateRequest.class})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<? extends Role>> listRolesOfUserOnTenant(@PathParam(value="userId") String var1, @PathParam(value="tenantId") String var2);
}

