/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.domain.Token;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Endpoint(value=Identity.class)
public interface TokenAsyncApi {
    @Named(value="token:get")
    @GET
    @SelectJson(value={"token"})
    @Consumes(value={"application/json"})
    @Path(value="/tokens/{token}")
    @RequestFilters(value={AuthenticateRequest.class})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends Token> get(@PathParam(value="token") String var1);

    @Named(value="token:getuser")
    @GET
    @SelectJson(value={"user"})
    @Consumes(value={"application/json"})
    @Path(value="/tokens/{token}")
    @RequestFilters(value={AuthenticateRequest.class})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ListenableFuture<? extends User> getUserOfToken(@PathParam(value="token") String var1);

    @Named(value="token:valid")
    @HEAD
    @Path(value="/tokens/{token}")
    @RequestFilters(value={AuthenticateRequest.class})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> isValid(@PathParam(value="token") String var1);

    @Named(value="token:listendpoints")
    @GET
    @SelectJson(value={"endpoints"})
    @Consumes(value={"application/json"})
    @Path(value="/tokens/{token}/endpoints")
    @RequestFilters(value={AuthenticateRequest.class})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<? extends org.jclouds.openstack.keystone.v2_0.domain.Endpoint>> listEndpointsForToken(@PathParam(value="token") String var1);
}

