/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.extensions.RoleAdminApi;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneApiLiveTest;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="RoleAdminApiLiveTest", singleThreaded=true)
public class RoleAdminApiLiveTest
extends BaseKeystoneApiLiveTest {
    private Optional<? extends RoleAdminApi> roleAdminOption;
    private Role testRole;

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.roleAdminOption = ((KeystoneApi)this.api).getRoleAdminApi();
        if (!this.roleAdminOption.isPresent()) {
            throw new SkipException("The tests are skipped since OS-KSADM extension is not exposed through the Keystone API");
        }
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.testRole != null) {
            final String roleId = this.testRole.getId();
            boolean success = ((RoleAdminApi)this.roleAdminOption.get()).delete(roleId);
            Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<RoleAdminApi>(){

                public boolean apply(RoleAdminApi roleApi) {
                    return roleApi.get(roleId) == null;
                }
            }, (long)5000L).apply(this.roleAdminOption.get()));
        }
        super.tearDown();
    }

    public void testCreateRole() {
        this.testRole = ((RoleAdminApi)this.roleAdminOption.get()).create("jclouds-test-role");
        Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<RoleAdminApi>(){

            public boolean apply(RoleAdminApi roleApi) {
                return roleApi.get(RoleAdminApiLiveTest.this.testRole.getId()) != null;
            }
        }, (long)180000L).apply(this.roleAdminOption.get()));
        Assert.assertEquals((String)((RoleAdminApi)this.roleAdminOption.get()).get(this.testRole.getId()).getName(), (String)"jclouds-test-role");
    }

    public void testListRoles() {
        RoleAdminApi roleApi = (RoleAdminApi)this.roleAdminOption.get();
        ImmutableSet roles = roleApi.list().toSet();
        Assert.assertNotNull((Object)roles);
        Assert.assertFalse((boolean)roles.isEmpty());
        for (Role role : roles) {
            Role aRole = roleApi.get(role.getId());
            Assert.assertEquals((Object)aRole, (Object)role);
        }
    }

    @Test(dependsOnMethods={"testCreateRole"})
    public void testGetRole() {
        Role testGetRole = ((RoleAdminApi)this.roleAdminOption.get()).get(this.testRole.getId());
        Assert.assertNotNull((Object)testGetRole);
        Assert.assertEquals((String)testGetRole.getName(), (String)"jclouds-test-role");
    }
}

