/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.extensions.RoleAdminApi;
import org.jclouds.openstack.v2_0.internal.BaseOpenStackMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RoleAdminApiMockTest")
public class RoleAdminApiMockTest
extends BaseOpenStackMockTest<KeystoneApi> {
    Set<Role> expectedRoles = ImmutableSet.of((Object)Role.builder().id("22529316b2384072b2e8946af5e8cfb6").name("admin").build(), (Object)Role.builder().id("9fe2ff9ee4384b1894a90878d3e92bab").name("_member_").description("Default role for project membership").build());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listRoles() throws Exception {
        MockWebServer server = RoleAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(200).setBody(this.stringFromResource("/role_list_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            RoleAdminApi roleAdminApi = (RoleAdminApi)keystoneApi.getRoleAdminApi().get();
            FluentIterable roles = roleAdminApi.list();
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateRoleRequest = server.takeRequest();
            Assert.assertEquals((String)updateRoleRequest.getRequestLine(), (String)"GET /OS-KSADM/roles HTTP/1.1");
            Assert.assertEquals((int)roles.size(), (int)2);
            Assert.assertEquals((Set)roles.toSet(), this.expectedRoles);
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listZeroRoles() throws Exception {
        MockWebServer server = RoleAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            RoleAdminApi roleAdminApi = (RoleAdminApi)keystoneApi.getRoleAdminApi().get();
            FluentIterable roles = roleAdminApi.list();
            ImmutableList roleList = roles.toList();
            Assert.assertTrue((boolean)roleList.isEmpty());
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateRoleRequest = server.takeRequest();
            Assert.assertEquals((String)updateRoleRequest.getRequestLine(), (String)"GET /OS-KSADM/roles HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRole() throws Exception {
        MockWebServer server = RoleAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201).setBody(this.stringFromResource("/role_create_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            RoleAdminApi roleAdminApi = (RoleAdminApi)keystoneApi.getRoleAdminApi().get();
            Role testRole = roleAdminApi.create("jclouds-role");
            Assert.assertNotNull((Object)testRole);
            Assert.assertEquals((String)testRole.getId(), (String)"r1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest createRoleRequest = server.takeRequest();
            Assert.assertEquals((String)createRoleRequest.getRequestLine(), (String)"POST /OS-KSADM/roles HTTP/1.1");
            Assert.assertEquals((String)new String(createRoleRequest.getBody()), (String)"{\"role\":{\"name\":\"jclouds-role\"}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRoleFail() throws Exception {
        MockWebServer server = RoleAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404).setBody(this.stringFromResource("/role_create_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            RoleAdminApi roleAdminApi = (RoleAdminApi)keystoneApi.getRoleAdminApi().get();
            Role testRole = roleAdminApi.create("jclouds-role");
            Assert.assertNull((Object)testRole);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest createRoleRequest = server.takeRequest();
            Assert.assertEquals((String)createRoleRequest.getRequestLine(), (String)"POST /OS-KSADM/roles HTTP/1.1");
            Assert.assertEquals((String)new String(createRoleRequest.getBody()), (String)"{\"role\":{\"name\":\"jclouds-role\"}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRole() throws Exception {
        MockWebServer server = RoleAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(200).setBody(this.stringFromResource("/role_create_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            RoleAdminApi roleAdminApi = (RoleAdminApi)keystoneApi.getRoleAdminApi().get();
            Role role = roleAdminApi.get("r1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateRoleRequest = server.takeRequest();
            Assert.assertEquals((String)updateRoleRequest.getRequestLine(), (String)"GET /OS-KSADM/roles/r1000 HTTP/1.1");
            Assert.assertEquals((String)role.getId(), (String)"r1000");
            Assert.assertEquals((String)role.getName(), (String)"jclouds-role");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRoleFail() throws Exception {
        MockWebServer server = RoleAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            RoleAdminApi roleAdminApi = (RoleAdminApi)keystoneApi.getRoleAdminApi().get();
            Role role = roleAdminApi.get("r1000");
            Assert.assertNull((Object)role);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateRoleRequest = server.takeRequest();
            Assert.assertEquals((String)updateRoleRequest.getRequestLine(), (String)"GET /OS-KSADM/roles/r1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRole() throws Exception {
        MockWebServer server = RoleAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(204)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            RoleAdminApi roleAdminApi = (RoleAdminApi)keystoneApi.getRoleAdminApi().get();
            boolean success = roleAdminApi.delete("r1000");
            Assert.assertTrue((boolean)success);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateRoleRequest = server.takeRequest();
            Assert.assertEquals((String)updateRoleRequest.getRequestLine(), (String)"DELETE /OS-KSADM/roles/r1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRoleFail() throws Exception {
        MockWebServer server = RoleAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            RoleAdminApi roleAdminApi = (RoleAdminApi)keystoneApi.getRoleAdminApi().get();
            boolean success = roleAdminApi.delete("r1000");
            Assert.assertFalse((boolean)success);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateRoleRequest = server.takeRequest();
            Assert.assertEquals((String)updateRoleRequest.getRequestLine(), (String)"DELETE /OS-KSADM/roles/r1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }
}

