/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Service;
import org.jclouds.openstack.keystone.v2_0.extensions.ServiceAdminApi;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneApiLiveTest;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ServiceAdminApiLiveTest", singleThreaded=true)
public class ServiceAdminApiLiveTest
extends BaseKeystoneApiLiveTest {
    private Optional<? extends ServiceAdminApi> serviceAdminOption;
    private Service testService;

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.serviceAdminOption = ((KeystoneApi)this.api).getServiceAdminApi();
        if (!this.serviceAdminOption.isPresent()) {
            throw new SkipException("The tests are skipped since OS-KSADM extension is not exposed through the Keystone API");
        }
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.testService != null) {
            final String serviceId = this.testService.getId();
            boolean success = ((ServiceAdminApi)this.serviceAdminOption.get()).delete(serviceId);
            Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<ServiceAdminApi>(){

                public boolean apply(ServiceAdminApi serviceApi) {
                    return serviceApi.get(serviceId) == null;
                }
            }, (long)5000L).apply(this.serviceAdminOption.get()));
        }
        super.tearDown();
    }

    public void testListServices() {
        ServiceAdminApi serviceApi = (ServiceAdminApi)this.serviceAdminOption.get();
        ImmutableSet services = serviceApi.list().concat().toSet();
        Assert.assertNotNull((Object)services);
        Assert.assertFalse((boolean)services.isEmpty());
        for (Service service : services) {
            Service aService = serviceApi.get(service.getId());
            Assert.assertEquals((Set)aService, (Set)service);
        }
    }

    @Test
    public void testCreateService() {
        this.testService = ((ServiceAdminApi)this.serviceAdminOption.get()).create("jclouds-test-service", "jclouds-service-type", "jclouds-service-description");
        Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<ServiceAdminApi>(){

            public boolean apply(ServiceAdminApi serviceApi) {
                return serviceApi.get(ServiceAdminApiLiveTest.this.testService.getId()) != null;
            }
        }, (long)180000L).apply(this.serviceAdminOption.get()));
        Assert.assertEquals((String)((ServiceAdminApi)this.serviceAdminOption.get()).get(this.testService.getId()).getName(), (String)"jclouds-test-service");
    }

    @Test(dependsOnMethods={"testCreateService"})
    public void testGetService() {
        Service testGetService = ((ServiceAdminApi)this.serviceAdminOption.get()).get(this.testService.getId());
        Assert.assertNotNull((Object)testGetService);
        Assert.assertEquals((String)testGetService.getName(), (String)"jclouds-test-service");
    }
}

