/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.util.Set;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Service;
import org.jclouds.openstack.keystone.v2_0.extensions.ServiceAdminApi;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.internal.BaseOpenStackMockTest;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ServiceAdminApiMockTest")
public class ServiceAdminApiMockTest
extends BaseOpenStackMockTest<KeystoneApi> {
    Set<Service> expectedServices = ImmutableSet.of((Object)Service.builder().name("neutron").type("network").id("150a35a1e24547fdb4122b7fc90929b0").description("Network Service").build(), (Object)Service.builder().name("cinder").type("volume").id("313b229fcede4a148f5bd11199264f8e").description("OpenStack Volume Service").build());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listServices() throws Exception {
        MockWebServer server = ServiceAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(200).setBody(this.stringFromResource("/service_list_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            ServiceAdminApi serviceAdminApi = (ServiceAdminApi)keystoneApi.getServiceAdminApi().get();
            PagedIterable services = serviceAdminApi.list();
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateServiceRequest = server.takeRequest();
            Assert.assertEquals((String)updateServiceRequest.getRequestLine(), (String)"GET /OS-KSADM/services HTTP/1.1");
            Assert.assertEquals((int)services.concat().size(), (int)2);
            Assert.assertEquals((Set)services.concat().toSet(), this.expectedServices);
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listZeroServices() throws Exception {
        MockWebServer server = ServiceAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            ServiceAdminApi serviceAdminApi = (ServiceAdminApi)keystoneApi.getServiceAdminApi().get();
            PagedIterable services = serviceAdminApi.list();
            ImmutableList servicesList = services.concat().toList();
            Assert.assertTrue((boolean)servicesList.isEmpty());
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateServiceRequest = server.takeRequest();
            Assert.assertEquals((String)updateServiceRequest.getRequestLine(), (String)"GET /OS-KSADM/services HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listServicesPage() throws Exception {
        MockWebServer server = ServiceAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(200).setBody(this.stringFromResource("/service_list_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            ServiceAdminApi serviceAdminApi = (ServiceAdminApi)keystoneApi.getServiceAdminApi().get();
            PaginatedCollection services = serviceAdminApi.list(new PaginationOptions());
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateServiceRequest = server.takeRequest();
            Assert.assertEquals((String)updateServiceRequest.getRequestLine(), (String)"GET /OS-KSADM/services HTTP/1.1");
            Assert.assertEquals((int)services.size(), (int)2);
            Assert.assertEquals((Set)services.toSet(), this.expectedServices);
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createService() throws Exception {
        MockWebServer server = ServiceAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201).setBody(this.stringFromResource("/service_create_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            ServiceAdminApi serviceAdminApi = (ServiceAdminApi)keystoneApi.getServiceAdminApi().get();
            Service testService = serviceAdminApi.create("jclouds-service-test", "jclouds-service-type", "jclouds-service-description");
            Assert.assertNotNull((Object)testService);
            Assert.assertEquals((String)testService.getId(), (String)"s1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest createServiceRequest = server.takeRequest();
            Assert.assertEquals((String)createServiceRequest.getRequestLine(), (String)"POST /OS-KSADM/services HTTP/1.1");
            String bodyRequest = new String(createServiceRequest.getBody());
            Assert.assertEquals((String)bodyRequest, (String)"{\"OS-KSADM:service\":{\"name\":\"jclouds-service-test\",\"type\":\"jclouds-service-type\",\"description\":\"jclouds-service-description\"}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createServiceFail() throws Exception {
        MockWebServer server = ServiceAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            ServiceAdminApi serviceAdminApi = (ServiceAdminApi)keystoneApi.getServiceAdminApi().get();
            Service testService = serviceAdminApi.create("jclouds-service-test", "jclouds-service-type", "jclouds-service-description");
            Assert.assertNull((Object)testService);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest createServiceRequest = server.takeRequest();
            Assert.assertEquals((String)createServiceRequest.getRequestLine(), (String)"POST /OS-KSADM/services HTTP/1.1");
            String bodyRequest = new String(createServiceRequest.getBody());
            Assert.assertEquals((String)bodyRequest, (String)"{\"OS-KSADM:service\":{\"name\":\"jclouds-service-test\",\"type\":\"jclouds-service-type\",\"description\":\"jclouds-service-description\"}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getService() throws Exception {
        MockWebServer server = ServiceAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(200).setBody(this.stringFromResource("/service_create_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            ServiceAdminApi serviceAdminApi = (ServiceAdminApi)keystoneApi.getServiceAdminApi().get();
            Service service = serviceAdminApi.get("s1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateServiceRequest = server.takeRequest();
            Assert.assertEquals((String)updateServiceRequest.getRequestLine(), (String)"GET /OS-KSADM/services/s1000 HTTP/1.1");
            Assert.assertEquals((String)service.getId(), (String)"s1000");
            Assert.assertEquals((String)service.getName(), (String)"jclouds-service-test");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getServiceFail() throws Exception {
        MockWebServer server = ServiceAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            ServiceAdminApi serviceAdminApi = (ServiceAdminApi)keystoneApi.getServiceAdminApi().get();
            Service service = serviceAdminApi.get("s1000");
            Assert.assertNull((Object)service);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateServiceRequest = server.takeRequest();
            Assert.assertEquals((String)updateServiceRequest.getRequestLine(), (String)"GET /OS-KSADM/services/s1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteService() throws Exception {
        MockWebServer server = ServiceAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(204)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            ServiceAdminApi serviceAdminApi = (ServiceAdminApi)keystoneApi.getServiceAdminApi().get();
            serviceAdminApi.delete("s1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateServiceRequest = server.takeRequest();
            Assert.assertEquals((String)updateServiceRequest.getRequestLine(), (String)"DELETE /OS-KSADM/services/s1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteServiceFail() throws Exception {
        MockWebServer server = ServiceAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            ServiceAdminApi serviceAdminApi = (ServiceAdminApi)keystoneApi.getServiceAdminApi().get();
            boolean success = serviceAdminApi.delete("s1000");
            Assert.assertFalse((boolean)success);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateServiceRequest = server.takeRequest();
            Assert.assertEquals((String)updateServiceRequest.getRequestLine(), (String)"DELETE /OS-KSADM/services/s1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }
}

