/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.extensions.TenantAdminApi;
import org.jclouds.openstack.keystone.v2_0.features.TenantApi;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneApiLiveTest;
import org.jclouds.openstack.keystone.v2_0.options.CreateTenantOptions;
import org.jclouds.openstack.keystone.v2_0.options.UpdateTenantOptions;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="TenantAdminApiLiveTest", singleThreaded=true)
public class TenantAdminApiLiveTest
extends BaseKeystoneApiLiveTest {
    private Optional<? extends TenantAdminApi> tenantAdminOption;
    private Optional<? extends TenantApi> tenantApi;
    private Tenant testTenant;

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.tenantAdminOption = ((KeystoneApi)this.api).getTenantAdminApi();
        if (!this.tenantAdminOption.isPresent()) {
            throw new SkipException("The tests are skipped since OS-KSADM extension is not exposed through the Keystone API");
        }
        this.tenantApi = ((KeystoneApi)this.api).getTenantApi();
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.testTenant != null) {
            final String tenantId = this.testTenant.getId();
            boolean success = ((TenantAdminApi)this.tenantAdminOption.get()).delete(tenantId);
            Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<TenantApi>(){

                public boolean apply(TenantApi tenantApi) {
                    return tenantApi.get(tenantId) == null;
                }
            }, (long)5000L).apply(this.tenantApi.get()));
        }
        super.tearDown();
    }

    public void testCreateTenant() {
        this.testTenant = ((TenantAdminApi)this.tenantAdminOption.get()).create("jclouds-test-tenant", CreateTenantOptions.Builder.enabled((boolean)true).description("jclouds-test-description"));
        Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<TenantApi>(){

            public boolean apply(TenantApi tenantApi) {
                return tenantApi.get(TenantAdminApiLiveTest.this.testTenant.getId()) != null;
            }
        }, (long)180000L).apply(this.tenantApi.get()));
        Assert.assertEquals((String)((TenantApi)this.tenantApi.get()).get(this.testTenant.getId()).getName(), (String)"jclouds-test-tenant");
        Assert.assertEquals((String)((TenantApi)this.tenantApi.get()).get(this.testTenant.getId()).getDescription(), (String)"jclouds-test-description");
        Assert.assertEquals((boolean)((TenantApi)this.tenantApi.get()).get(this.testTenant.getId()).isEnabled(), (boolean)true);
    }

    public void testUpdateTenant() {
        this.testTenant = ((TenantAdminApi)this.tenantAdminOption.get()).update(this.testTenant.getId(), UpdateTenantOptions.Builder.description((String)"jclouds-test-description-modified").enabled(false).name("jclouds-test-tenant-modified"));
        Assert.assertEquals((String)((TenantApi)this.tenantApi.get()).get(this.testTenant.getId()).getName(), (String)"jclouds-test-tenant-modified");
        Assert.assertEquals((String)((TenantApi)this.tenantApi.get()).get(this.testTenant.getId()).getDescription(), (String)"jclouds-test-description-modified");
        Assert.assertEquals((boolean)((TenantApi)this.tenantApi.get()).get(this.testTenant.getId()).isEnabled(), (boolean)false);
    }
}

