/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.extensions.TenantAdminApi;
import org.jclouds.openstack.keystone.v2_0.options.CreateTenantOptions;
import org.jclouds.openstack.keystone.v2_0.options.UpdateTenantOptions;
import org.jclouds.openstack.v2_0.internal.BaseOpenStackMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TenantAdminApiMockTest")
public class TenantAdminApiMockTest
extends BaseOpenStackMockTest<KeystoneApi> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTenant() throws Exception {
        MockWebServer server = TenantAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201).setBody(this.stringFromResource("/tenant_create_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            TenantAdminApi tenantAdminApi = (TenantAdminApi)keystoneApi.getTenantAdminApi().get();
            CreateTenantOptions createTenantOptions = CreateTenantOptions.Builder.description((String)"jclouds-description").enabled(true);
            Tenant testTenant = tenantAdminApi.create("jclouds-tenant", createTenantOptions);
            Assert.assertNotNull((Object)testTenant);
            Assert.assertEquals((String)testTenant.getId(), (String)"t1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest createTenantRequest = server.takeRequest();
            Assert.assertEquals((String)createTenantRequest.getRequestLine(), (String)"POST /tenants HTTP/1.1");
            Assert.assertEquals((String)new String(createTenantRequest.getBody()), (String)"{\"tenant\":{\"name\":\"jclouds-tenant\",\"description\":\"jclouds-description\",\"enabled\":true}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTenantFail() throws Exception {
        MockWebServer server = TenantAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            TenantAdminApi tenantAdminApi = (TenantAdminApi)keystoneApi.getTenantAdminApi().get();
            CreateTenantOptions createTenantOptions = CreateTenantOptions.Builder.description((String)"jclouds-description").enabled(true);
            Tenant testTenant = tenantAdminApi.create("jclouds-tenant", createTenantOptions);
            Assert.assertNull((Object)testTenant);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest createTenantRequest = server.takeRequest();
            Assert.assertEquals((String)createTenantRequest.getRequestLine(), (String)"POST /tenants HTTP/1.1");
            Assert.assertEquals((String)new String(createTenantRequest.getBody()), (String)"{\"tenant\":{\"name\":\"jclouds-tenant\",\"description\":\"jclouds-description\",\"enabled\":true}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTenant() throws Exception {
        MockWebServer server = TenantAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(200).setBody(this.stringFromResource("/tenant_update_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            TenantAdminApi tenantAdminApi = (TenantAdminApi)keystoneApi.getTenantAdminApi().get();
            UpdateTenantOptions updateTenantOptions = UpdateTenantOptions.Builder.description((String)"jclouds-description-modified").enabled(false).name("jclouds-tenant-modified");
            Tenant updatedTenant = tenantAdminApi.update("t1000", updateTenantOptions);
            Assert.assertNotNull((Object)updatedTenant);
            Assert.assertEquals((String)updatedTenant.getId(), (String)"t1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateTenantRequest = server.takeRequest();
            Assert.assertEquals((String)updateTenantRequest.getRequestLine(), (String)"PUT /tenants/t1000 HTTP/1.1");
            Assert.assertEquals((String)new String(updateTenantRequest.getBody()), (String)"{\"tenant\":{\"name\":\"jclouds-tenant-modified\",\"description\":\"jclouds-description-modified\",\"enabled\":false}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTenantFail() throws Exception {
        MockWebServer server = TenantAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            TenantAdminApi tenantAdminApi = (TenantAdminApi)keystoneApi.getTenantAdminApi().get();
            UpdateTenantOptions updateTenantOptions = UpdateTenantOptions.Builder.description((String)"jclouds-description-modified").enabled(false).name("jclouds-tenant-modified");
            Tenant updatedTenant = tenantAdminApi.update("t1000", updateTenantOptions);
            Assert.assertNull((Object)updatedTenant);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateTenantRequest = server.takeRequest();
            Assert.assertEquals((String)updateTenantRequest.getRequestLine(), (String)"PUT /tenants/t1000 HTTP/1.1");
            Assert.assertEquals((String)new String(updateTenantRequest.getBody()), (String)"{\"tenant\":{\"name\":\"jclouds-tenant-modified\",\"description\":\"jclouds-description-modified\",\"enabled\":false}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTenant() throws Exception {
        MockWebServer server = TenantAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(204)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            TenantAdminApi tenantAdminApi = (TenantAdminApi)keystoneApi.getTenantAdminApi().get();
            tenantAdminApi.delete("t1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateTenantRequest = server.takeRequest();
            Assert.assertEquals((String)updateTenantRequest.getRequestLine(), (String)"DELETE /tenants/t1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTenantFail() throws Exception {
        MockWebServer server = TenantAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            TenantAdminApi tenantAdminApi = (TenantAdminApi)keystoneApi.getTenantAdminApi().get();
            boolean success = tenantAdminApi.delete("t1000");
            Assert.assertFalse((boolean)success);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateTenantRequest = server.takeRequest();
            Assert.assertEquals((String)updateTenantRequest.getRequestLine(), (String)"DELETE /tenants/t1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoleOnTenant() throws Exception {
        MockWebServer server = TenantAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            TenantAdminApi tenantAdminApi = (TenantAdminApi)keystoneApi.getTenantAdminApi().get();
            tenantAdminApi.addRoleOnTenant("u1000", "t1000", "r1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateTenantRequest = server.takeRequest();
            Assert.assertEquals((String)updateTenantRequest.getRequestLine(), (String)"PUT /tenants/u1000/users/t1000/roles/OS-KSADM/r1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoleOnTenantFail() throws Exception {
        MockWebServer server = TenantAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            TenantAdminApi tenantAdminApi = (TenantAdminApi)keystoneApi.getTenantAdminApi().get();
            boolean success = tenantAdminApi.addRoleOnTenant("u1000", "t1000", "r1000");
            Assert.assertFalse((boolean)success);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateTenantRequest = server.takeRequest();
            Assert.assertEquals((String)updateTenantRequest.getRequestLine(), (String)"PUT /tenants/u1000/users/t1000/roles/OS-KSADM/r1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRoleOnTenant() throws Exception {
        MockWebServer server = TenantAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(204)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            TenantAdminApi tenantAdminApi = (TenantAdminApi)keystoneApi.getTenantAdminApi().get();
            tenantAdminApi.deleteRoleOnTenant("t1000", "u1000", "r1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateTenantRequest = server.takeRequest();
            Assert.assertEquals((String)updateTenantRequest.getRequestLine(), (String)"DELETE /tenants/t1000/users/u1000/roles/OS-KSADM/r1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRoleOnTenantFail() throws Exception {
        MockWebServer server = TenantAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            TenantAdminApi tenantAdminApi = (TenantAdminApi)keystoneApi.getTenantAdminApi().get();
            boolean success = tenantAdminApi.deleteRoleOnTenant("t1000", "u1000", "r1000");
            Assert.assertFalse((boolean)success);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateTenantRequest = server.takeRequest();
            Assert.assertEquals((String)updateTenantRequest.getRequestLine(), (String)"DELETE /tenants/t1000/users/u1000/roles/OS-KSADM/r1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }
}

