/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.extensions.UserAdminApi;
import org.jclouds.openstack.keystone.v2_0.features.UserApi;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneApiLiveTest;
import org.jclouds.openstack.keystone.v2_0.options.CreateUserOptions;
import org.jclouds.openstack.keystone.v2_0.options.UpdateUserOptions;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="UserAdminApiLiveTest", singleThreaded=true)
public class UserAdminApiLiveTest
extends BaseKeystoneApiLiveTest {
    private Optional<? extends UserAdminApi> userAdminOption;
    private Optional<? extends UserApi> userApi;
    private User testUser;

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.userAdminOption = ((KeystoneApi)this.api).getUserAdminApi();
        if (!this.userAdminOption.isPresent()) {
            throw new SkipException("The tests are skipped since OS-KSADM extension is not exposed through the Keystone API");
        }
        this.userApi = ((KeystoneApi)this.api).getUserApi();
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.testUser != null) {
            final String userId = this.testUser.getId();
            boolean success = ((UserAdminApi)this.userAdminOption.get()).delete(userId);
            Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<UserApi>(){

                public boolean apply(UserApi userApi) {
                    return userApi.get(userId) == null;
                }
            }, (long)5000L).apply(this.userApi.get()));
        }
        super.tearDown();
    }

    @Test
    public void testCreateUser() {
        this.testUser = ((UserAdminApi)this.userAdminOption.get()).create("jclouds-test-user", "jclouds-test-password", CreateUserOptions.Builder.email((String)"jclouds-test@jclouds.org").enabled(true));
        Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<UserApi>(){

            public boolean apply(UserApi userApi) {
                return userApi.get(UserAdminApiLiveTest.this.testUser.getId()) != null;
            }
        }, (long)180000L).apply(this.userApi.get()));
        Assert.assertEquals((String)((UserApi)this.userApi.get()).get(this.testUser.getId()).getName(), (String)"jclouds-test-user");
        Assert.assertEquals((String)((UserApi)this.userApi.get()).get(this.testUser.getId()).getEmail(), (String)"jclouds-test@jclouds.org");
        Assert.assertEquals((boolean)((UserApi)this.userApi.get()).get(this.testUser.getId()).isEnabled(), (boolean)true);
    }

    @Test(dependsOnMethods={"testCreateUser"})
    public void testUpdateUser() {
        this.testUser = ((UserAdminApi)this.userAdminOption.get()).update(this.testUser.getId(), UpdateUserOptions.Builder.email((String)"jclouds-test.modified@jclouds.org").enabled(false).name("jclouds-test-user-modified").password("jclouds-test-password-modified"));
        Assert.assertEquals((String)((UserApi)this.userApi.get()).get(this.testUser.getId()).getName(), (String)"jclouds-test-user-modified");
        Assert.assertEquals((String)((UserApi)this.userApi.get()).get(this.testUser.getId()).getEmail(), (String)"jclouds-test.modified@jclouds.org");
        Assert.assertEquals((boolean)((UserApi)this.userApi.get()).get(this.testUser.getId()).isEnabled(), (boolean)false);
    }
}

