/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.extensions;

import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.extensions.UserAdminApi;
import org.jclouds.openstack.keystone.v2_0.options.CreateUserOptions;
import org.jclouds.openstack.keystone.v2_0.options.UpdateUserOptions;
import org.jclouds.openstack.v2_0.internal.BaseOpenStackMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="UserAdminApiMockTest")
public class UserAdminApiMockTest
extends BaseOpenStackMockTest<KeystoneApi> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUser() throws Exception {
        MockWebServer server = UserAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(201).setBody(this.stringFromResource("/user_create_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            UserAdminApi userAdminApi = (UserAdminApi)keystoneApi.getUserAdminApi().get();
            CreateUserOptions createUserOptions = CreateUserOptions.Builder.email((String)"john.smith@example.org").enabled(true);
            User testUser = userAdminApi.create("jqsmith", "jclouds-password", createUserOptions);
            Assert.assertNotNull((Object)testUser);
            Assert.assertEquals((String)testUser.getId(), (String)"u1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest createUserRequest = server.takeRequest();
            Assert.assertEquals((String)createUserRequest.getRequestLine(), (String)"POST /users HTTP/1.1");
            Assert.assertEquals((String)new String(createUserRequest.getBody()), (String)"{\"user\":{\"name\":\"jqsmith\",\"password\":\"jclouds-password\",\"email\":\"john.smith@example.org\",\"enabled\":true}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUserFail() throws Exception {
        MockWebServer server = UserAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            UserAdminApi userAdminApi = (UserAdminApi)keystoneApi.getUserAdminApi().get();
            CreateUserOptions createUserOptions = CreateUserOptions.Builder.email((String)"john.smith@example.org").enabled(true);
            User testUser = userAdminApi.create("jqsmith", "jclouds-password", createUserOptions);
            Assert.assertNull((Object)testUser);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest createUserRequest = server.takeRequest();
            Assert.assertEquals((String)createUserRequest.getRequestLine(), (String)"POST /users HTTP/1.1");
            Assert.assertEquals((String)new String(createUserRequest.getBody()), (String)"{\"user\":{\"name\":\"jqsmith\",\"password\":\"jclouds-password\",\"email\":\"john.smith@example.org\",\"enabled\":true}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUser() throws Exception {
        MockWebServer server = UserAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(200).setBody(this.stringFromResource("/user_update_response.json"))));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            UserAdminApi userAdminApi = (UserAdminApi)keystoneApi.getUserAdminApi().get();
            UpdateUserOptions updateUserOptions = UpdateUserOptions.Builder.email((String)"john.smith.renamed@example.org").enabled(false).name("jqsmith-renamed").password("jclouds-password");
            User updatedUser = userAdminApi.update("u1000", updateUserOptions);
            Assert.assertNotNull((Object)updatedUser);
            Assert.assertEquals((String)updatedUser.getId(), (String)"u1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateUserRequest = server.takeRequest();
            Assert.assertEquals((String)updateUserRequest.getRequestLine(), (String)"PUT /users/u1000 HTTP/1.1");
            Assert.assertEquals((String)new String(updateUserRequest.getBody()), (String)"{\"user\":{\"name\":\"jqsmith-renamed\",\"email\":\"john.smith.renamed@example.org\",\"password\":\"jclouds-password\",\"enabled\":false}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserFail() throws Exception {
        MockWebServer server = UserAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            UserAdminApi userAdminApi = (UserAdminApi)keystoneApi.getUserAdminApi().get();
            UpdateUserOptions updateUserOptions = UpdateUserOptions.Builder.email((String)"john.smith.renamed@example.org").enabled(false).name("jqsmith-renamed").password("jclouds-password");
            User updatedUser = userAdminApi.update("u1000", updateUserOptions);
            Assert.assertNull((Object)updatedUser);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateUserRequest = server.takeRequest();
            Assert.assertEquals((String)updateUserRequest.getRequestLine(), (String)"PUT /users/u1000 HTTP/1.1");
            Assert.assertEquals((String)new String(updateUserRequest.getBody()), (String)"{\"user\":{\"name\":\"jqsmith-renamed\",\"email\":\"john.smith.renamed@example.org\",\"password\":\"jclouds-password\",\"enabled\":false}}");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser() throws Exception {
        MockWebServer server = UserAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(204)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            UserAdminApi userAdminApi = (UserAdminApi)keystoneApi.getUserAdminApi().get();
            userAdminApi.delete("u1000");
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateUserRequest = server.takeRequest();
            Assert.assertEquals((String)updateUserRequest.getRequestLine(), (String)"DELETE /users/u1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUserFail() throws Exception {
        MockWebServer server = UserAdminApiMockTest.mockOpenStackServer();
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/access_version_uids.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setBody(this.stringFromResource("/admin_extensions.json"))));
        server.enqueue(this.addCommonHeaders(new MockResponse().setResponseCode(404)));
        try {
            KeystoneApi keystoneApi = (KeystoneApi)this.api(server.getUrl("/").toString(), "openstack-keystone");
            UserAdminApi userAdminApi = (UserAdminApi)keystoneApi.getUserAdminApi().get();
            boolean success = userAdminApi.delete("u1000");
            Assert.assertFalse((boolean)success);
            Assert.assertEquals((int)server.getRequestCount(), (int)3);
            this.assertAuthentication(server);
            this.assertExtensions(server);
            RecordedRequest updateUserRequest = server.takeRequest();
            Assert.assertEquals((String)updateUserRequest.getRequestLine(), (String)"DELETE /users/u1000 HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }
}

