/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.features.ServiceApi;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneRestApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="ServiceApiExpectTest")
public class ServiceApiExpectTest
extends BaseKeystoneRestApiExpectTest<KeystoneApi> {
    public void testListTenants() {
        ServiceApi api = ((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tenants").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/tenant_list.json", "application/json"))).build())).getServiceApi();
        Set tenants = api.listTenants();
        Assert.assertNotNull((Object)tenants);
        Assert.assertFalse((boolean)tenants.isEmpty());
        ImmutableSet expected = ImmutableSet.of((Object)Tenant.builder().name("demo").id("05d1dc7af71646deba64cfc17b81bec0").enabled(Boolean.valueOf(true)).build(), (Object)Tenant.builder().name("admin").id("7aa2e17ec29f44d193c48feaba0852cc").enabled(Boolean.valueOf(true)).build());
        Assert.assertEquals((Set)tenants, (Set)expected);
    }

    public void testListTenantsFailNotFound() {
        ServiceApi api = ((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/tenants").build(), HttpResponse.builder().statusCode(404).build())).getServiceApi();
        Assert.assertTrue((boolean)api.listTenants().isEmpty());
    }
}

