/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.ImmutableSet;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.features.TenantApi;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="TenantApiLiveTest")
public class TenantApiLiveTest
extends BaseKeystoneApiLiveTest {
    public void testTenants() {
        TenantApi tenantApi = (TenantApi)((KeystoneApi)this.api).getTenantApi().get();
        ImmutableSet result = tenantApi.list().concat().toSet();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        for (Tenant tenant : result) {
            Assert.assertNotNull((Object)tenant.getId());
            Tenant aTenant = tenantApi.get(tenant.getId());
            Assert.assertNotNull((Object)aTenant, (String)("get returned null for tenant: " + tenant));
            Assert.assertEquals((Object)aTenant, (Object)tenant);
        }
    }

    public void testTenantsByName() {
        TenantApi tenantApi = (TenantApi)((KeystoneApi)this.api).getTenantApi().get();
        for (Tenant tenant : tenantApi.list().concat()) {
            Tenant aTenant = tenantApi.getByName(tenant.getName());
            Assert.assertNotNull((Object)aTenant, (String)("get returned null for tenant: " + tenant));
            Assert.assertEquals((Object)aTenant, (Object)tenant);
        }
    }
}

