/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.features.UserApi;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneRestApiExpectTest;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.AuthorizationException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true, testName="UserApiExpectTest")
public class UserApiExpectTest
extends BaseKeystoneRestApiExpectTest<KeystoneApi> {
    Set<User> expectedUsers = ImmutableSet.of((Object)User.builder().name("nova").id("e021dfd758eb44a89f1c57c8ef3be8e2").email("nova@example.com").enabled(Boolean.valueOf(true)).tenantId("ab1da202f5774cceb5da2aeff1f0aa87").build(), (Object)User.builder().name("glance").id("3f6c1c9ba993495ead7d2eb2192e284f").email("glance@example.com").enabled(Boolean.valueOf(true)).tenantId("ab1da202f5774cceb5da2aeff1f0aa87").build(), (Object)User.builder().name("demo").id("667b2e1420604df8b67cd8ea57d4ee64").email("demo@example.com").enabled(Boolean.valueOf(true)).tenantId(null).build(), (Object)User.builder().name("admin").id("2b9b606181634ae9ac86fd95a8bc2cde").email("admin@example.com").enabled(Boolean.valueOf(true)).tenantId(null).build());

    public UserApiExpectTest() {
        this.endpoint = "https://csnode.jclouds.org:35357";
    }

    public void testListUsers() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/user_list.json", "application/json"))).build())).getUserApi().get();
        Assert.assertEquals((Set)api.list().concat().toSet(), this.expectedUsers);
    }

    public void testListUsersPage() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/user_list.json", "application/json"))).build())).getUserApi().get();
        PaginatedCollection users = api.list(new PaginationOptions());
        Assert.assertNotNull((Object)users);
        Assert.assertFalse((boolean)users.isEmpty());
        Assert.assertEquals((Set)users.toSet(), this.expectedUsers);
    }

    public void testListUsersNotFound() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users").build(), HttpResponse.builder().statusCode(404).build())).getUserApi().get();
        Assert.assertEquals((int)api.list(new PaginationOptions()).size(), (int)0);
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testListUsersFailNotAuth() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users").build(), HttpResponse.builder().statusCode(401).build())).getUserApi().get();
        api.list(new PaginationOptions());
    }

    public void testGetUser() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users/e021dfd758eb44a89f1c57c8ef3be8e2").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/user_details.json", "application/json"))).build())).getUserApi().get();
        User user = api.get("e021dfd758eb44a89f1c57c8ef3be8e2");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Set)user, (Set)User.builder().name("nova").id("e021dfd758eb44a89f1c57c8ef3be8e2").email("nova@example.com").enabled(Boolean.valueOf(true)).tenantId("ab1da202f5774cceb5da2aeff1f0aa87").build());
    }

    public void testGetUserFailNotFound() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users/f021dfd758eb44a89f1c57c8ef3be8e2").build(), HttpResponse.builder().statusCode(404).build())).getUserApi().get();
        Assert.assertNull((Object)api.get("f021dfd758eb44a89f1c57c8ef3be8e2"));
    }

    public void testGetUserByName() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users?name=nova").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/user_details.json", "application/json"))).build())).getUserApi().get();
        User user = api.getByName("nova");
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Set)user, (Set)User.builder().name("nova").id("e021dfd758eb44a89f1c57c8ef3be8e2").email("nova@example.com").enabled(Boolean.valueOf(true)).tenantId("ab1da202f5774cceb5da2aeff1f0aa87").build());
    }

    public void testGetUserByNameFailNotFound() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users?name=fred").build(), HttpResponse.builder().statusCode(404).build())).getUserApi().get();
        Assert.assertNull((Object)api.getByName("fred"));
    }

    public void testListRolesOfUser() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users/3f6c1c9ba993495ead7d2eb2192e284f/roles").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/user_role_list.json", "application/json"))).build())).getUserApi().get();
        Set roles = api.listRolesOfUser("3f6c1c9ba993495ead7d2eb2192e284f");
        Assert.assertNotNull((Object)roles);
        Assert.assertFalse((boolean)roles.isEmpty());
        Assert.assertEquals((Set)roles, (Set)ImmutableSet.of((Object)Role.builder().id("79cada5c02814b57a52e0eed4dd388cb").name("admin").build()));
    }

    public void testListRolesOfUserFailNotFound() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users/4f6c1c9ba993495ead7d2eb2192e284f/roles").build(), HttpResponse.builder().statusCode(404).build())).getUserApi().get();
        Assert.assertTrue((boolean)api.listRolesOfUser("4f6c1c9ba993495ead7d2eb2192e284f").isEmpty());
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testListRolesOfUserFailNotImplemented() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users/5f6c1c9ba993495ead7d2eb2192e284f/roles").build(), HttpResponse.builder().statusCode(501).build())).getUserApi().get();
        Assert.assertTrue((boolean)api.listRolesOfUser("5f6c1c9ba993495ead7d2eb2192e284f").isEmpty());
    }

    public void testListRolesOfUserInTenant() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users/3f6c1c9ba993495ead7d2eb2192e284f/roles").build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/user_tenant_role_list.json", "application/json"))).build())).getUserApi().get();
        Set roles = api.listRolesOfUser("3f6c1c9ba993495ead7d2eb2192e284f");
        Assert.assertNotNull((Object)roles);
        Assert.assertFalse((boolean)roles.isEmpty());
        Assert.assertEquals((Set)roles, (Set)ImmutableSet.of((Object)Role.builder().id("31c451195aac49b386039341e2c92a16").name("KeystoneServiceAdmin").build(), (Object)Role.builder().id("79cada5c02814b57a52e0eed4dd388cb").name("admin").build(), (Object)Role.builder().id("6ea17ddd37a6447794cb0e164d4db894").name("KeystoneAdmin").build()));
    }

    public void testListRolesOfUserInTenantFailNotFound() {
        UserApi api = (UserApi)((KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(this.endpoint + "/v2.0/users/3f6c1c9ba993495ead7d2eb2192e284f/roles").build(), HttpResponse.builder().statusCode(404).build())).getUserApi().get();
        Assert.assertTrue((boolean)api.listRolesOfUser("3f6c1c9ba993495ead7d2eb2192e284f").isEmpty());
    }
}

