/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.parse;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.Consumes;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.json.BaseItemParserTest;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneParserModule;
import org.jclouds.openstack.keystone.v2_0.domain.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.domain.MediaType;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.rest.annotations.SelectJson;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseApiMetadataTest")
public class ParseRackspaceApiMetadataTest
extends BaseItemParserTest<ApiMetadata> {
    public String resource() {
        return "/raxVersion.json";
    }

    @SelectJson(value={"version"})
    @Consumes(value={"application/json"})
    public ApiMetadata expected() {
        return ((ApiMetadata.Builder)((ApiMetadata.Builder)ApiMetadata.builder().id("v2.0")).links((Set)ImmutableSet.of((Object)Link.builder().relation(Link.Relation.SELF).href(URI.create("https://identity.api.rackspacecloud.com/v2.0")).build(), (Object)Link.builder().relation(Link.Relation.DESCRIBEDBY).type("application/pdf").href(URI.create("http://docs.rackspacecloud.com/auth/api/v2.0/auth-client-devguide-latest.pdf")).build(), (Object)Link.builder().relation(Link.Relation.DESCRIBEDBY).type("application/vnd.sun.wadl+xml").href(URI.create("http://docs.rackspacecloud.com/auth/api/v2.0/auth.wadl")).build()))).status("BETA").updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2012-01-21T11:33:21-06:00")).mediaTypes((Set)ImmutableSet.of((Object)MediaType.builder().base("application/xml").type("application/vnd.openstack.identity+xml;version=2.0").build(), (Object)MediaType.builder().base("application/json").type("application/vnd.openstack.identity+json;version=2.0").build())).build();
    }

    protected Injector injector() {
        return Guice.createInjector((Module[])new Module[]{new GsonModule(), new KeystoneParserModule()});
    }
}

