/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Singleton;
import org.jclouds.location.Provider;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.parse.ParseAccessTest;
import org.jclouds.openstack.keystone.v2_0.parse.ParseRackspaceAccessTest;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURIFromAccessForTypeAndVersion;
import org.jclouds.openstack.keystone.v2_0.suppliers.RegionIdToAdminURISupplier;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RegionIdToAdminURIFromAccessForTypeAndVersionTest")
public class RegionIdToAdminURIFromAccessForTypeAndVersionTest {
    private final RegionIdToAdminURISupplier.Factory factory = (RegionIdToAdminURISupplier.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith(Provider.class).to("openstack-keystone");
            this.bind((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}).annotatedWith(Provider.class).toInstance((Object)Suppliers.ofInstance((Object)URI.create("https://identity")));
            this.install(new FactoryModuleBuilder().implement(RegionIdToAdminURISupplier.class, RegionIdToAdminURIFromAccessForTypeAndVersion.class).build(RegionIdToAdminURISupplier.Factory.class));
        }

        @Provides
        @Singleton
        public Supplier<Access> provide() {
            return Suppliers.ofInstance((Object)new ParseAccessTest().expected());
        }
    }}).getInstance(RegionIdToAdminURISupplier.Factory.class);
    private final RegionIdToAdminURISupplier.Factory raxFactory = (RegionIdToAdminURISupplier.Factory)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bindConstant().annotatedWith(Provider.class).to("rackspace");
            this.bind((TypeLiteral)new TypeLiteral<Supplier<URI>>(){}).annotatedWith(Provider.class).toInstance((Object)Suppliers.ofInstance((Object)URI.create("https://identity")));
            this.install(new FactoryModuleBuilder().implement(RegionIdToAdminURISupplier.class, RegionIdToAdminURIFromAccessForTypeAndVersion.class).build(RegionIdToAdminURISupplier.Factory.class));
        }

        @Provides
        @Singleton
        public Supplier<Access> provide() {
            return Suppliers.ofInstance((Object)new ParseRackspaceAccessTest().expected());
        }
    }}).getInstance(RegionIdToAdminURISupplier.Factory.class);

    public void testRegionMatches() {
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)this.factory.createForApiTypeAndVersion("identity", "2.0").get()), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"region-a.geo-1", (Object)URI.create("https://csnode.jclouds.org:35357/v2.0/")));
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put("region-a.geo-1", null);
        map.put("region-b.geo-1", null);
        map.put("region-c.geo-1", null);
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)this.factory.createForApiTypeAndVersion("compute", "2").get()), (Function)Suppliers.supplierFunction()), (Map)map);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testWhenNotInList() {
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)this.raxFactory.createForApiTypeAndVersion("goo", "1.0").get()), (Function)Suppliers.supplierFunction()), (Map)ImmutableMap.of((Object)"rackspace", (Object)URI.create("https://servers.api.rackspacecloud.com/v1.0/40806637803162")));
    }

    public void testProviderWhenNoRegions() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put("rackspace", null);
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)this.raxFactory.createForApiTypeAndVersion("compute", "1.0").get()), (Function)Suppliers.supplierFunction()), (Map)map);
    }

    public void testOkWithNoVersions() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put("DFW", null);
        map.put("ORD", null);
        Assert.assertEquals((Map)Maps.transformValues((Map)((Map)this.raxFactory.createForApiTypeAndVersion("rax:database", null).get()), (Function)Suppliers.supplierFunction()), (Map)map);
    }
}

