/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.functions;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.reflect.Invokable;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.openstack.v2_0.domain.Extension;
import org.jclouds.openstack.v2_0.functions.PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.InvocationSuccess;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.annotations.Delegate;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSetTest")
public class PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSetTest {
    org.jclouds.openstack.v2_0.domain.Extension keypairs = ((Extension.Builder)org.jclouds.openstack.v2_0.domain.Extension.builder().alias("os-keypairs").name("Keypairs")).namespace(URI.create("http://docs.openstack.org/ext/keypairs/api/v1.1")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-08-08T00:00:00+00:00")).description("Keypair Support").build();
    org.jclouds.openstack.v2_0.domain.Extension floatingIps = ((Extension.Builder)org.jclouds.openstack.v2_0.domain.Extension.builder().alias("os-floating-ips").name("Floating_ips")).namespace(URI.create("http://docs.openstack.org/ext/floating_ips/api/v1.1")).updated(new SimpleDateFormatDateService().iso8601SecondsDateParse("2011-06-16T00:00:00+00:00")).description("Floating IPs support").build();

    InvocationSuccess getFloatingIPExtension(List<Object> args) throws SecurityException, NoSuchMethodException {
        return InvocationSuccess.create((Invocation)Invocation.create((Invokable)Reflection2.method(NovaAsyncApi.class, (String)"getFloatingIPExtensionForZone", (Class[])new Class[]{String.class}), args), (Object)"foo");
    }

    InvocationSuccess getKeyPairExtension(List<Object> args) throws SecurityException, NoSuchMethodException {
        return InvocationSuccess.create((Invocation)Invocation.create((Invokable)Reflection2.method(NovaAsyncApi.class, (String)"getKeyPairExtensionForZone", (Class[])new Class[]{String.class}), args), (Object)"foo");
    }

    public void testPresentWhenExtensionsIncludeNamespaceFromAnnotationAbsentWhenNot() throws SecurityException, NoSuchMethodException {
        Assert.assertEquals((Object)this.whenExtensionsInZoneInclude("zone", this.keypairs, this.floatingIps).apply(this.getFloatingIPExtension((List<Object>)ImmutableList.of((Object)"zone"))), (Object)Optional.of((Object)"foo"));
        Assert.assertEquals((Object)this.whenExtensionsInZoneInclude("zone", this.keypairs, this.floatingIps).apply(this.getKeyPairExtension((List<Object>)ImmutableList.of((Object)"zone"))), (Object)Optional.of((Object)"foo"));
        Assert.assertEquals((Object)this.whenExtensionsInZoneInclude("zone", this.keypairs).apply(this.getFloatingIPExtension((List<Object>)ImmutableList.of((Object)"zone"))), (Object)Optional.absent());
        Assert.assertEquals((Object)this.whenExtensionsInZoneInclude("zone", this.floatingIps).apply(this.getKeyPairExtension((List<Object>)ImmutableList.of((Object)"zone"))), (Object)Optional.absent());
    }

    public void testZoneWithoutExtensionsReturnsAbsent() throws SecurityException, NoSuchMethodException {
        Assert.assertEquals((Object)this.whenExtensionsInZoneInclude("zone", this.floatingIps).apply(this.getFloatingIPExtension((List<Object>)ImmutableList.of((Object)"differentzone"))), (Object)Optional.absent());
        Assert.assertEquals((Object)this.whenExtensionsInZoneInclude("zone", this.keypairs).apply(this.getKeyPairExtension((List<Object>)ImmutableList.of((Object)"differentzone"))), (Object)Optional.absent());
    }

    public void testPresentWhenAliasForExtensionMapsToNamespace() throws SecurityException, NoSuchMethodException {
        org.jclouds.openstack.v2_0.domain.Extension keypairsWithDifferentNamespace = this.keypairs.toBuilder().namespace(URI.create("http://docs.openstack.org/ext/arbitrarilydifferent/keypairs/api/v1.1")).build();
        ImmutableMultimap aliases = ImmutableMultimap.of((Object)this.keypairs.getNamespace(), (Object)keypairsWithDifferentNamespace.getNamespace());
        Assert.assertEquals((Object)this.whenExtensionsAndAliasesInZoneInclude("zone", (Set<org.jclouds.openstack.v2_0.domain.Extension>)ImmutableSet.of((Object)keypairsWithDifferentNamespace), (Multimap<URI, URI>)aliases).apply(this.getKeyPairExtension((List<Object>)ImmutableList.of((Object)"zone"))), (Object)Optional.of((Object)"foo"));
        Assert.assertEquals((Object)this.whenExtensionsAndAliasesInZoneInclude("zone", (Set<org.jclouds.openstack.v2_0.domain.Extension>)ImmutableSet.of((Object)keypairsWithDifferentNamespace), (Multimap<URI, URI>)aliases).apply(this.getFloatingIPExtension((List<Object>)ImmutableList.of((Object)"zone"))), (Object)Optional.absent());
    }

    private PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet whenExtensionsInZoneInclude(String zone, org.jclouds.openstack.v2_0.domain.Extension ... extensions) {
        return this.whenExtensionsAndAliasesInZoneInclude(zone, (Set<org.jclouds.openstack.v2_0.domain.Extension>)ImmutableSet.copyOf((Object[])extensions), (Multimap<URI, URI>)ImmutableMultimap.of());
    }

    private PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet whenExtensionsAndAliasesInZoneInclude(String zone, Set<org.jclouds.openstack.v2_0.domain.Extension> extensions, final Multimap<URI, URI> aliases) {
        final LoadingCache extensionsForZone = CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.forMap((Map)ImmutableMap.of((Object)zone, extensions, (Object)"differentzone", (Object)ImmutableSet.of()))));
        PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet fn = (PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
            }

            @Provides
            LoadingCache<String, Set<? extends org.jclouds.openstack.v2_0.domain.Extension>> getExtensions() {
                return extensionsForZone;
            }

            @Provides
            Multimap<URI, URI> getAliases() {
                return aliases;
            }
        }}).getInstance(PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet.class);
        return fn;
    }

    static interface NovaAsyncApi {
        @Delegate
        public Optional<FloatingIPAsyncApi> getFloatingIPExtensionForZone(String var1);

        @Delegate
        public Optional<KeyPairAsyncApi> getKeyPairExtensionForZone(String var1);
    }

    @Extension(of="compute", namespace="http://docs.openstack.org/ext/floating_ips/api/v1.1")
    static interface FloatingIPAsyncApi {
    }

    @Extension(of="compute", namespace="http://docs.openstack.org/ext/keypairs/api/v1.1")
    static interface KeyPairAsyncApi {
    }
}

