/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.internal;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.inject.Module;
import com.squareup.okhttp.mockwebserver.Dispatcher;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.QueueDispatcher;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import org.jclouds.ContextBuilder;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.util.Strings2;
import org.testng.Assert;

public class BaseOpenStackMockTest<A extends Closeable> {
    @Deprecated
    public static final String accessRackspace = "{\"access\":{\"token\":{\"id\":\"b84f4a37-5126-4603-9521-ccd0665fbde1\",\"expires\":\"2013-04-13T16:49:57.000-05:00\",\"tenant\":{\"id\":\"123123\",\"name\":\"123123\"}},\"serviceCatalog\":[{\"endpoints\":[{\"tenantId\":\"123123\",\"publicURL\":\"URL/v1.0/123123\"}],\"name\":\"cloudMonitoring\",\"type\":\"rax:monitor\"},{\"endpoints\":[{\"region\":\"DFW\",\"tenantId\":\"MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9\",\"publicURL\":\"URL/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9\"},{\"region\":\"ORD\",\"tenantId\":\"MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9\",\"publicURL\":\"URL/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9\"}],\"name\":\"cloudFilesCDN\",\"type\":\"rax:object-cdn\"},{\"endpoints\":[{\"region\":\"ORD\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v1.0/123123\"},{\"region\":\"DFW\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v1.0/123123\"}],\"name\":\"cloudLoadBalancers\",\"type\":\"rax:load-balancer\"},{\"endpoints\":[{\"region\":\"DFW\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v1.0/123123\"},{\"region\":\"ORD\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v1.0/123123\"}],\"name\":\"cloudDatabases\",\"type\":\"rax:database\"},{\"endpoints\":[{\"region\":\"DFW\",\"tenantId\":\"MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9\",\"publicURL\":\"URL/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9\",\"internalURL\":\"URL/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9\"},{\"region\":\"ORD\",\"tenantId\":\"MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9\",\"publicURL\":\"URL/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9\",\"internalURL\":\"URL/v1/MossoCloudFS_5bcf396e-39dd-45ff-93a1-712b9aba90a9\"}],\"name\":\"cloudFiles\",\"type\":\"object-store\"},{\"endpoints\":[{\"tenantId\":\"123123\",\"publicURL\":\"URL/v1.0/123123\",\"versionInfo\":\"URL/v1.0\",\"versionList\":\"URL/\",\"versionId\":\"1.0\"}],\"name\":\"cloudServers\",\"type\":\"compute\"},{\"endpoints\":[{\"region\":\"DFW\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v2/123123\",\"versionInfo\":\"URL/v2\",\"versionList\":\"URL/\",\"versionId\":\"2\"},{\"region\":\"ORD\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v2/123123\",\"versionInfo\":\"URL/v2\",\"versionList\":\"URL/\",\"versionId\":\"2\"}],\"name\":\"cloudServersOpenStack\",\"type\":\"compute\"},{\"endpoints\":[{\"tenantId\":\"123123\",\"publicURL\":\"URL/v1.0/123123\"}],\"name\":\"cloudDNS\",\"type\":\"rax:dns\"},{\"endpoints\":[{\"tenantId\":\"123123\",\"publicURL\":\"URL/v1.0/123123\"}],\"name\":\"cloudBackup\",\"type\":\"rax:backup\"},{\"endpoints\":[{\"region\":\"DFW\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v1/123123\"},{\"region\":\"ORD\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v1/123123\"}],\"name\":\"cloudBlockStorage\",\"type\":\"volume\"},{\"endpoints\":[{\"region\":\"DFW\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v1/123123\",\"internalURL\":\"URL/v1/123123\"},{\"region\":\"ORD\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v1/123123\",\"internalURL\":\"URL/v1/123123\"}],\"name\":\"marconi\",\"type\":\"queuing\"},{\"endpoints\":[{\"region\":\"DFW\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v1/123123\",\"internalURL\":\"URL/v1/123123\"},{\"region\":\"ORD\",\"tenantId\":\"123123\",\"publicURL\":\"URL/v1/123123\",\"internalURL\":\"URL/v1/123123\"}],\"name\":\"autoscale\",\"type\":\"rax:autoscale\"}],\"user\":{\"id\":\"1234\",\"roles\":[{\"id\":\"3\",\"description\":\"User Admin Role.\",\"name\":\"identity:user-admin\"}],\"name\":\"jclouds-joe\",\"RAX-AUTH:defaultRegion\":\"DFW\"}}}";
    private final Set<Module> modules = ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()));
    private static final Pattern urlTokenPattern = Pattern.compile(":\\s*\"\\s*URL");

    public A api(String uri, String provider, Properties overrides) {
        if (!overrides.containsKey("jclouds.max-retries")) {
            overrides.setProperty("jclouds.max-retries", "1");
        }
        return (A)ContextBuilder.newBuilder((String)provider).credentials("jclouds:joe", "letmein").endpoint(uri).overrides(overrides).modules(this.modules).buildApi(new TypeToken<A>(this.getClass()){});
    }

    public A api(String uri, String provider) {
        return this.api(uri, provider, new Properties());
    }

    public static MockWebServer mockOpenStackServer() throws IOException {
        MockWebServer server = new MockWebServer();
        server.play();
        URL url = server.getUrl("");
        server.setDispatcher((Dispatcher)BaseOpenStackMockTest.getURLReplacingQueueDispatcher(url));
        return server;
    }

    public static QueueDispatcher getURLReplacingQueueDispatcher(final URL url) {
        QueueDispatcher dispatcher = new QueueDispatcher(){
            protected final BlockingQueue<MockResponse> responseQueue = new LinkedBlockingQueue<MockResponse>();

            public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                MockResponse response = this.responseQueue.take();
                if (response.getBody() != null) {
                    String newBody = urlTokenPattern.matcher(new String(response.getBody())).replaceAll(": \"" + url.toString());
                    response = response.setBody(newBody);
                }
                return response;
            }

            public void enqueueResponse(MockResponse response) {
                this.responseQueue.add(response);
            }
        };
        return dispatcher;
    }

    public MockResponse addCommonHeaders(MockResponse mockResponse) {
        mockResponse.addHeader("Accept", (Object)MediaType.JSON_UTF_8.withoutParameters());
        return mockResponse;
    }

    public String stringFromResource(String resourceName) {
        try {
            return Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream(resourceName));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void assertAuthentication(MockWebServer server) {
        Assert.assertTrue((server.getRequestCount() >= 1 ? 1 : 0) != 0);
        try {
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"POST /tokens HTTP/1.1");
        }
        catch (InterruptedException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void assertExtensions(MockWebServer server) {
        Assert.assertTrue((server.getRequestCount() >= 1 ? 1 : 0) != 0);
        try {
            Assert.assertEquals((String)server.takeRequest().getRequestLine(), (String)"GET /extensions HTTP/1.1");
        }
        catch (InterruptedException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void assertContentTypeIsJSON(RecordedRequest request) {
        Assert.assertTrue((boolean)request.getHeaders().contains("Content-Type: application/json"));
    }

    public void assertRequest(RecordedRequest request, String method, String path) {
        Assert.assertEquals((String)request.getMethod(), (String)method);
        Assert.assertEquals((String)request.getPath(), (String)path);
    }

    public void assertRequest(RecordedRequest request, String method, String path, String resourceLocation) {
        this.assertRequest(request, method, path);
        this.assertContentTypeIsJSON(request);
        JsonParser parser = new JsonParser();
        JsonElement requestJson = null;
        try {
            requestJson = parser.parse(new String(request.getBody(), "UTF-8"));
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        JsonElement resourceJson = parser.parse(this.stringFromResource(resourceLocation));
        Assert.assertEquals((Object)requestJson, (Object)resourceJson);
    }
}

