/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="PaginationOptionsTest")
public class PaginationOptionsTest {
    public void testChangesSince() {
        Date ifModifiedSince = new Date();
        PaginationOptions options = new PaginationOptions().changesSince(ifModifiedSince);
        Assert.assertEquals((Collection)ImmutableList.of((Object)(ifModifiedSince.getTime() / 1000L + "")), (Collection)options.buildQueryParameters().get((Object)"changes-since"));
    }

    public void testMarker() {
        String marker = "52415800-8b69-11e0-9b19-734f6f006e54";
        PaginationOptions options = new PaginationOptions().marker(marker);
        Assert.assertEquals((Collection)ImmutableList.of((Object)marker), (Collection)options.buildQueryParameters().get((Object)"marker"));
    }

    public void testMaxResults() {
        int limit = 1;
        PaginationOptions options = new PaginationOptions().limit(limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"limit"));
    }

    public void testChangesSinceStatic() {
        Date ifModifiedSince = new Date();
        PaginationOptions options = PaginationOptions.Builder.changesSince((Date)ifModifiedSince);
        Assert.assertEquals((Collection)ImmutableList.of((Object)(ifModifiedSince.getTime() / 1000L + "")), (Collection)options.buildQueryParameters().get((Object)"changes-since"));
    }

    public void testMarkerStatic() {
        String marker = "52415800-8b69-11e0-9b19-734f6f006e54";
        PaginationOptions options = PaginationOptions.Builder.marker((String)marker);
        Assert.assertEquals((Collection)ImmutableList.of((Object)marker), (Collection)options.buildQueryParameters().get((Object)"marker"));
    }

    public void testMaxResultsStatic() {
        int limit = 1;
        PaginationOptions options = PaginationOptions.Builder.limit((int)limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildQueryParameters().get((Object)"limit"));
    }
}

